/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.provisional.format;

import java.util.Vector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatContraints;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.StringUtils;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.NodeFormatter;

public class TextNodeFormatter
extends NodeFormatter {
    protected void formatNode(IDOMNode node, IStructuredFormatContraints formatContraints) {
        if (node != null) {
            IStructuredDocument doc = node.getModel().getStructuredDocument();
            int line = doc.getLineOfOffset(node.getStartOffset());
            String lineDelimiter = doc.getLineDelimiter();
            try {
                lineDelimiter = doc.getLineDelimiter(line);
                if (lineDelimiter == null) {
                    lineDelimiter = "";
                }
            }
            catch (BadLocationException e) {
                Logger.log(1, e.getMessage());
            }
            int lineWidth = this.getFormatPreferences().getLineWidth();
            IDOMNode parentNode = (IDOMNode)node.getParentNode();
            String nodeIndentation = formatContraints.getCurrentIndent();
            int currentAvailableLineWidth = 0;
            try {
                int nodeNameOffset = node.getStartOffset();
                int lineOffset = node.getStructuredDocument().getLineInformationOfOffset(nodeNameOffset).getOffset();
                String text = node.getStructuredDocument().get(lineOffset, nodeNameOffset - lineOffset);
                int usedWidth = this.getIndentationLength(text);
                currentAvailableLineWidth = this.getFormatPreferences().getLineWidth() - usedWidth;
            }
            catch (BadLocationException e) {
                Logger.log(1, e.getMessage());
            }
            String compressedText = this.getCompressedNodeText(node, formatContraints);
            if (!((compressedText.length() > currentAvailableLineWidth - node.getParentNode().getNodeName().length() - 3 || StringUtils.containsLineDelimiter((String)compressedText) || this.nodeHasSiblings(node) && (StringUtils.containsLineDelimiter((String)node.getNodeValue()) || node.getNextSibling() == null || node.getNextSibling().getNodeType() != 8 || StringUtils.containsLineDelimiter((String)node.getNextSibling().getNodeValue())) || this.firstStructuredDocumentRegionContainsLineDelimiters((IDOMNode)node.getParentNode())) && node.getStartStructuredDocumentRegion().getStartOffset() != 0)) {
                if (this.isEndTagMissing(parentNode)) {
                    parentNode = (IDOMNode)parentNode.getParentNode();
                    while (this.isEndTagMissing(parentNode)) {
                        parentNode = (IDOMNode)parentNode.getParentNode();
                    }
                    nodeIndentation = this.getNodeIndent(parentNode);
                    if (!compressedText.endsWith(String.valueOf(lineDelimiter) + nodeIndentation)) {
                        compressedText = StringUtils.appendIfNotEndWith((String)compressedText, (String)lineDelimiter);
                        compressedText = StringUtils.appendIfNotEndWith((String)compressedText, (String)nodeIndentation);
                    }
                }
                if (parentNode != null && parentNode.getNodeType() == 9 && node.getNodeValue().length() > 0 && node.getNodeValue().trim().length() == 0 && (node.getPreviousSibling() == null || node.getNextSibling() == null)) {
                    compressedText = "";
                }
                this.replaceNodeValue(node, compressedText);
            } else {
                currentAvailableLineWidth = lineWidth - this.getIndentationLength(nodeIndentation);
                Vector vector = this.reflowText(compressedText, currentAvailableLineWidth);
                int vectorSize = vector.size();
                String reflowedText = new String();
                int i = 0;
                while (i < vectorSize) {
                    reflowedText = ((String)vector.get(i)).trim().length() > 0 ? String.valueOf(reflowedText) + lineDelimiter + nodeIndentation + (String)vector.get(i) : String.valueOf(reflowedText) + lineDelimiter;
                    ++i;
                }
                if (node.getNextSibling() == null) {
                    if (!this.isEndTagMissing(parentNode)) {
                        nodeIndentation = this.getNodeIndent(parentNode);
                        if (!reflowedText.endsWith(String.valueOf(lineDelimiter) + nodeIndentation)) {
                            reflowedText = StringUtils.appendIfNotEndWith((String)reflowedText, (String)lineDelimiter);
                            reflowedText = StringUtils.appendIfNotEndWith((String)reflowedText, (String)nodeIndentation);
                        }
                    }
                } else if (!reflowedText.endsWith(String.valueOf(lineDelimiter) + nodeIndentation)) {
                    if (node.getNextSibling().getNodeType() == 8) {
                        boolean currentTextEndsWithLineDelimiter;
                        String nodeText = this.getNodeText(node);
                        int indexOfLastLineDelimiter = StringUtils.indexOfLastLineDelimiter((String)nodeText);
                        boolean bl = currentTextEndsWithLineDelimiter = indexOfLastLineDelimiter != -1;
                        if (currentTextEndsWithLineDelimiter) {
                            currentTextEndsWithLineDelimiter = StringUtils.indexOfNonblank((String)nodeText, (int)indexOfLastLineDelimiter) == -1;
                        }
                        String nodeValue = node.getNextSibling().getNodeValue();
                        boolean multiLineComment = StringUtils.containsLineDelimiter((String)nodeValue);
                        if (currentTextEndsWithLineDelimiter || multiLineComment) {
                            reflowedText = StringUtils.appendIfNotEndWith((String)reflowedText, (String)lineDelimiter);
                            reflowedText = StringUtils.appendIfNotEndWith((String)reflowedText, (String)nodeIndentation);
                        }
                    } else {
                        reflowedText = StringUtils.appendIfNotEndWith((String)reflowedText, (String)lineDelimiter);
                        reflowedText = StringUtils.appendIfNotEndWith((String)reflowedText, (String)nodeIndentation);
                    }
                }
                this.replaceNodeValue(node, reflowedText);
            }
        }
    }

    protected Vector reflowText(String text, int availableWidth) {
        String[] stringArray = null;
        boolean clearAllBlankLines = this.getFormatPreferences().getClearAllBlankLines();
        stringArray = clearAllBlankLines ? StringUtils.asArray((String)text) : StringUtils.asArray((String)text, (String)" \t\n\r\f", (boolean)true);
        Vector<String> output = new Vector<String>();
        if (stringArray != null && stringArray.length > 0) {
            StringBuffer buffer = new StringBuffer();
            if (stringArray[0].compareTo("\r") != 0) {
                buffer.append(stringArray[0]);
            }
            int bufferLength = stringArray[0].toString().length();
            boolean cr = stringArray[0].compareTo("\r") == 0;
            int i = 1;
            while (i < stringArray.length) {
                String eachString = stringArray[i];
                if (eachString.compareTo(" ") != 0 && eachString.compareTo("\t") != 0 && eachString.compareTo("\f") != 0) {
                    if (bufferLength + 1 + eachString.length() > availableWidth || eachString.compareTo("\r") == 0 || eachString.compareTo("\n") == 0) {
                        if (eachString.compareTo("\n") != 0 || !cr) {
                            output.add(buffer.toString());
                            buffer = new StringBuffer();
                            bufferLength = 0;
                        }
                        cr = eachString.compareTo("\r") == 0;
                    } else if (buffer.toString().trim().length() > 0) {
                        buffer.append(" ");
                        ++bufferLength;
                    }
                    if (eachString.compareTo("\r") != 0 && eachString.compareTo("\n") != 0) {
                        buffer.append(eachString);
                        bufferLength += eachString.length();
                    }
                }
                ++i;
            }
            output.add(buffer.toString());
        } else {
            output.add(text);
        }
        return output;
    }
}

