/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.commands;

import org.eclipse.core.resources.IFile;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.commands.AbstractCommand;
import org.eclipse.wst.xsd.ui.internal.commands.AddModelGroupCommand;
import org.eclipse.wst.xsd.ui.internal.commands.AddSimpleTypeDefinitionCommand;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xsd.XSDComponentSelectionDialog;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xsd.XSDComponentSelectionProvider;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xsd.XSDSetTypeHelper;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class SetTypeCommand
extends AbstractCommand {
    protected int typeKind = 9;

    public SetTypeCommand(XSDConcreteComponent parent) {
        super(parent);
    }

    public void setTypeKind(int type) {
        this.typeKind = type;
    }

    public void run() {
        XSDConcreteComponent parent = this.getParent();
        if (parent instanceof XSDElementDeclaration) {
            XSDElementDeclaration element = (XSDElementDeclaration)parent;
            XSDSchema schema = element.getSchema();
            if (this.typeKind == 9) {
                AddModelGroupCommand sequenceCommand = new AddModelGroupCommand((XSDConcreteComponent)element, XSDCompositor.SEQUENCE_LITERAL);
                sequenceCommand.run();
            } else if (this.typeKind == 37) {
                AddSimpleTypeDefinitionCommand stCommand = new AddSimpleTypeDefinitionCommand((XSDConcreteComponent)element, null);
                stCommand.run();
                XSDSimpleTypeDefinition st = (XSDSimpleTypeDefinition)stCommand.getModelObject();
                XSDSimpleTypeDefinition base = schema.resolveSimpleTypeDefinition(schema.getSchemaForSchemaNamespace(), "string");
                st.setBaseTypeDefinition(base);
            } else {
                Shell shell = Display.getCurrent().getActiveShell();
                IFile currentIFile = ((IFileEditorInput)this.getActiveEditor().getEditorInput()).getFile();
                XSDComponentSelectionProvider provider = new XSDComponentSelectionProvider(currentIFile, schema);
                XSDComponentSelectionDialog dialog = new XSDComponentSelectionDialog(shell, XSDEditorPlugin.getXSDString("_UI_LABEL_SET_TYPE"), provider);
                provider.setDialog(dialog);
                dialog.setBlockOnOpen(true);
                dialog.create();
                if (dialog.open() == 0) {
                    XSDSetTypeHelper helper = new XSDSetTypeHelper(currentIFile, schema);
                    helper.setType(element.getElement(), "type", dialog.getSelection());
                }
            }
            this.formatChild(element.getElement());
        }
    }

    private IEditorPart getActiveEditor() {
        IWorkbench workbench = XSDEditorPlugin.getPlugin().getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IEditorPart editorPart = workbenchWindow.getActivePage().getActiveEditor();
        return editorPart;
    }

    protected boolean adopt(XSDConcreteComponent model) {
        return false;
    }
}

