/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xsd.ui.internal.util.ViewUtility;

public abstract class OptionsTextCellEditor
extends CellEditor
implements SelectionListener,
KeyListener {
    private Composite fEditor;
    protected Text fText;
    protected boolean isTextReadOnly;
    Button moreButton;
    Shell dialog;
    protected Object fValue;
    int selection;
    Object typeObject;

    public OptionsTextCellEditor(Composite parent) {
        super(parent);
    }

    protected Control createControl(Composite parent) {
        this.fEditor = ViewUtility.createComposite(parent, 2);
        this.fEditor.setLayout((Layout)new ComboCellLayout());
        this.fText = this.isTextReadOnly ? new Text(this.fEditor, 16392) : new Text(this.fEditor, 16384);
        this.fText.setBackground(parent.getBackground());
        this.fText.setText("");
        this.fText.addKeyListener((KeyListener)this);
        this.fText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!OptionsTextCellEditor.this.moreButton.isFocusControl()) {
                    OptionsTextCellEditor.this.focusLost();
                }
            }
        });
        this.moreButton = ViewUtility.createPushButton(this.fEditor, "...");
        this.moreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionsTextCellEditor.this.openDialog();
            }
        });
        this.moreButton.addKeyListener((KeyListener)this);
        this.moreButton.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!OptionsTextCellEditor.this.fText.isFocusControl() && (OptionsTextCellEditor.this.dialog == null || OptionsTextCellEditor.this.dialog.isDisposed() || OptionsTextCellEditor.this.dialog != null && !OptionsTextCellEditor.this.dialog.isFocusControl())) {
                    OptionsTextCellEditor.this.focusLost();
                }
            }
        });
        this.setValueValid(true);
        return this.fEditor;
    }

    public void activate() {
        this.fText.setText(this.fValue == null ? "" : this.fValue.toString());
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    void applyEditorValueAndDeactivate() {
        this.fireApplyEditorValue();
        this.deactivate();
    }

    public void keyPressed(KeyEvent e) {
        if (e.character == '\u001b') {
            this.fireCancelEditor();
        } else if (e.character == '\r' || e.character == '\n') {
            this.applyEditorValueAndDeactivate();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    protected Object doGetValue() {
        return this.fValue;
    }

    protected void doSetFocus() {
        this.fText.setFocus();
    }

    protected void doSetValue(Object value) {
        this.fValue = value;
    }

    protected Point getButtonAbsoluteLocation() {
        Rectangle buttonBounds = this.moreButton.getBounds();
        int x = buttonBounds.x;
        int y = buttonBounds.y;
        Button c = this.moreButton;
        while (c != null) {
            if ((c = c.getParent()) == null) break;
            x += c.getBounds().x;
            y += c.getBounds().y;
        }
        Point p = new Point(x += buttonBounds.width + 5, y += buttonBounds.height);
        return p;
    }

    protected void cancel() {
        this.dialog.close();
        this.dialog.dispose();
    }

    protected abstract void openDialog();

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private class ComboCellLayout
    extends Layout {
        ComboCellLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point size = OptionsTextCellEditor.this.moreButton.computeSize(-1, bounds.height, force);
            OptionsTextCellEditor.this.fText.setBounds(0, 0, bounds.width - size.x, bounds.height);
            OptionsTextCellEditor.this.moreButton.setBounds(bounds.width - size.x, 0, size.x, size.y);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point size = OptionsTextCellEditor.this.fText.computeSize(-1, -1, force);
            return size;
        }
    }
}

