/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import java.util.ArrayList;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.BasePropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.SimpleContentPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.properties.XSDComboBoxPropertyDescriptor;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleContentPropertySource
extends BasePropertySource
implements IPropertySource {
    private String DERIVED_BY_ID = "derived by";
    private String BASE_TYPE_ID = "base";
    private String[] derivedByChoicesComboValues = new String[]{"", "restriction", "extension"};

    public SimpleContentPropertySource() {
    }

    public SimpleContentPropertySource(Viewer viewer, XSDSchema xsdSchema) {
        super(viewer, xsdSchema);
    }

    public SimpleContentPropertySource(XSDSchema xsdSchema) {
        super(xsdSchema);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>();
        SimpleContentPropertyDescriptor typeDescriptor = new SimpleContentPropertyDescriptor(this.BASE_TYPE_ID, this.BASE_TYPE_ID, this.element, this.xsdSchema);
        list.add(typeDescriptor);
        XSDComboBoxPropertyDescriptor derivedByDescriptor = new XSDComboBoxPropertyDescriptor(this.DERIVED_BY_ID, this.DERIVED_BY_ID, this.derivedByChoicesComboValues);
        list.add(derivedByDescriptor);
        IPropertyDescriptor[] result = new IPropertyDescriptor[list.size()];
        list.toArray(result);
        return result;
    }

    public Object getPropertyValue(Object id) {
        if (id instanceof String) {
            if (((String)id).equals(this.DERIVED_BY_ID)) {
                String derivedBy = this.getDomHelper().getDerivedByName(this.element);
                if (derivedBy == null) {
                    derivedBy = "";
                }
                return derivedBy;
            }
            if (((String)id).equals(this.BASE_TYPE_ID)) {
                String baseType = this.getDomHelper().getBaseType(this.element);
                if (baseType == null) {
                    baseType = "";
                }
                return baseType;
            }
        }
        return "";
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (value != null && value instanceof String) {
            String origBaseType = this.getDomHelper().getBaseType(this.element);
            String derivedBy = this.getDomHelper().getDerivedByName(this.element);
            if (((String)id).equals(this.BASE_TYPE_ID)) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_TYPE_CHANGE"), this.element);
                this.getDomHelper().setDerivedByBaseType(this.element, derivedBy, (String)value);
                this.endRecording(this.element);
            } else if (((String)id).equals(this.DERIVED_BY_ID)) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_DERIVEDBY_CHANGE"), this.element);
                String newDerivedBy = (String)value;
                if (newDerivedBy.equals("restriction")) {
                    String prefix = this.element.getPrefix();
                    String anyType = prefix == null ? "anyType" : String.valueOf(prefix) + ":anyType";
                    this.getDomHelper().changeDerivedByType(this.element, (String)value, anyType);
                } else {
                    Element derivedByElem = this.getDomHelper().getDerivedByElement(this.element);
                    this.checkForAnonymousType(derivedByElem);
                    this.getDomHelper().changeDerivedByType(this.element, (String)value, origBaseType);
                }
                this.endRecording(this.element);
            }
        }
        Runnable delayedUpdate = new Runnable(){

            public void run() {
                if (SimpleContentPropertySource.this.viewer != null) {
                    SimpleContentPropertySource.this.viewer.refresh();
                }
            }
        };
        Display.getCurrent().asyncExec(delayedUpdate);
    }

    boolean checkForAnonymousType(Element element) {
        boolean isAnonymous = false;
        Node aNode = this.getDomHelper().getChildNode(element, "simpleType");
        if (aNode != null) {
            return true;
        }
        return isAnonymous;
    }
}

