/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wildwebdeveloper.tests.TestAngular;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestESLint {
    private IProject project;

    @Before
    public void setUpProject() throws Exception {
        ScopedPreferenceStore prefs = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.lsp4e");
        prefs.putValue("org.eclipse.wildwebdeveloper.angular.file.logging.enabled", Boolean.toString(true));
        prefs.putValue("org.eclipse.wildwebdeveloper.jsts.file.logging.enabled", Boolean.toString(true));
        prefs.putValue("org.eclipse.wildwebdeveloper.css.file.logging.enabled", Boolean.toString(true));
        prefs.putValue("org.eclipse.wildwebdeveloper.html.file.logging.enabled", Boolean.toString(true));
        prefs.putValue("org.eclipse.wildwebdeveloper.json.file.logging.enabled", Boolean.toString(true));
        prefs.putValue("org.eclipse.wildwebdeveloper.xml.file.logging.enabled", Boolean.toString(true));
        prefs.putValue("org.eclipse.wildwebdeveloper.yaml.file.logging.enabled", Boolean.toString(true));
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(this.getClass().getName()) + System.nanoTime());
        this.project.create(null);
        this.project.open(null);
        IFile eslintConfig = this.project.getFile(".eslintrc");
        eslintConfig.create(this.getClass().getResourceAsStream("/testProjects/eslint/.eslintrc"), true, null);
        IFile tsConfig = this.project.getFile("tsconfig.json");
        tsConfig.create(this.getClass().getResourceAsStream("/testProjects/eslint/tsconfig.json"), true, null);
        IFile packageJson = this.project.getFile("package.json");
        packageJson.create(this.getClass().getResourceAsStream("/testProjects/eslint/package.json"), true, null);
        Process dependencyInstaller = new ProcessBuilder(TestAngular.getNpmLocation(), "install").directory(this.project.getLocation().toFile()).start();
        Assert.assertEquals((String)"npm install didn't complete properly", (long)0L, (long)dependencyInstaller.waitFor());
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference[] iViewReferenceArray = activePage.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            activePage.hideView(ref);
            ++n2;
        }
    }

    @After
    public void deleteProjectAndCloseEditors() throws Exception {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
        this.project.delete(true, null);
    }

    @Test
    public void testESLintDiagnosticsTS() throws Exception {
        final IFile file = this.project.getFile("blah.ts");
        file.create(this.getClass().getResourceAsStream("/testProjects/eslint/ESLintProj.ts"), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        DisplayHelper.sleep((long)4000L);
        Assert.assertTrue((String)"Diagnostic not published", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L));
        Assert.assertTrue((String)"Diagnostic content is incorrect", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0)[0].getAttribute("message", null).contains("[@typescript-eslint/explicit-function-return-type] Missing return type on function.");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L));
    }

    @Test
    public void testESLintDiagnosticsJS() throws Exception {
        final IFile file = this.project.getFile("blah.js");
        file.create(this.getClass().getResourceAsStream("/testProjects/eslint/ESLintProj.js"), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        DisplayHelper.sleep((long)4000L);
        Assert.assertTrue((String)"Diagnostic not published", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L));
        Assert.assertTrue((String)"Diagnostic content is incorrect", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0)[0].getAttribute("message", null).contains("[@typescript-eslint/indent] Expected indentation of 0 spaces but found 9.");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L));
    }
}

