/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wildwebdeveloper.embedder.node.Activator;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class TestNodeJsEmbedder {
    @Rule
    public AllCleanRule allClean = new AllCleanRule();

    @Test
    public void testNodeJsEmbedder() throws Exception {
        URL nodeJsInfo = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("nodejs-info.properties"));
        Assert.assertNotNull((String)"NodeJs descriptor \"nodejs-info.properties\" not found!", (Object)nodeJsInfo);
        Properties properties = new Properties();
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream infoStream = nodeJsInfo.openStream();){
            properties.load(infoStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertTrue((String)"Property \"archiveURL\" is not defined", (properties.getProperty("archiveURL") != null && !properties.getProperty("archiveURL").isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Property \"archiveFile\" is not defined", (properties.getProperty("archiveFile") != null && !properties.getProperty("archiveFile").isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Property \"nodePath\" is not defined", (properties.getProperty("nodePath") != null && !properties.getProperty("nodePath").isEmpty() ? 1 : 0) != 0);
        File nodePath = NodeJSManager.getNodeJsLocation();
        Assert.assertNotNull((String)"Node.Js location cannot be found", (Object)nodePath);
        IPath stateLocationPath = InternalPlatform.getDefault().getStateLocation(Platform.getBundle((String)"org.eclipse.wildwebdeveloper.embedder.node"));
        Assert.assertNotNull((String)"State location cannot be found for plugin \"org.eclipse.wildwebdeveloper.embedder.node\"", (Object)stateLocationPath);
        File installationPath = stateLocationPath.toFile();
        File embeddedNodePath = new File(installationPath, properties.getProperty("nodePath"));
        Assert.assertTrue((String)"Embedded NodeJs is not extracted", (nodePath.exists() && nodePath.canRead() && nodePath.canExecute() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Embedded NodeJs installation is not used", (Object)nodePath, (Object)embeddedNodePath);
    }

    @Test
    public void testNodeJsEmbedderWhich() throws Exception {
        URL nodeJsInfo = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("nodejs-info.properties"));
        Assert.assertNotNull((String)"NodeJs descriptor \"nodejs-info.properties\" not found!", (Object)nodeJsInfo);
        Properties properties = new Properties();
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream infoStream = nodeJsInfo.openStream();){
            properties.load(infoStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertTrue((String)"Property \"archiveURL\" is not defined", (properties.getProperty("archiveURL") != null && !properties.getProperty("archiveURL").isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Property \"archiveFile\" is not defined", (properties.getProperty("archiveFile") != null && !properties.getProperty("archiveFile").isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Property \"nodePath\" is not defined", (properties.getProperty("nodePath") != null && !properties.getProperty("nodePath").isEmpty() ? 1 : 0) != 0);
        File nodePath = NodeJSManager.getNodeJsLocation();
        Assert.assertNotNull((String)"Node.Js location cannot be found", (Object)nodePath);
        IPath stateLocationPath = InternalPlatform.getDefault().getStateLocation(Platform.getBundle((String)"org.eclipse.wildwebdeveloper.embedder.node"));
        Assert.assertNotNull((String)"State location cannot be found for plugin \"org.eclipse.wildwebdeveloper.embedder.node\"", (Object)stateLocationPath);
        File installationPath = stateLocationPath.toFile();
        File embeddedNodePath = new File(installationPath, properties.getProperty("nodePath"));
        Assert.assertTrue((String)"Embedded NodeJs is not extracted", (nodePath.exists() && nodePath.canRead() && nodePath.canExecute() ? 1 : 0) != 0);
        File whichNode = NodeJSManager.which((String)"node");
        Assert.assertTrue((String)"NodeJSManager.which(\"node\") didn't return an embedded NodeJs", (whichNode.exists() && whichNode.canRead() && whichNode.canExecute() && embeddedNodePath.getParent().equals(whichNode.getParent()) ? 1 : 0) != 0);
        File whichNpm = NodeJSManager.which((String)"npm");
        Assert.assertTrue((String)"NodeJSManager.which(\"npm\") didn't return an embedded NodeJs's NPM", (whichNpm.exists() && whichNpm.canRead() && whichNpm.canExecute() && embeddedNodePath.getParent().equals(whichNpm.getParent()) ? 1 : 0) != 0);
        File whichNpx = NodeJSManager.which((String)"npx");
        Assert.assertTrue((String)"NodeJSManager.which(\"npx\") didn't return an embedded NodeJs\\'s NPX", (whichNpx.exists() && whichNpx.canRead() && whichNpx.canExecute() && embeddedNodePath.getParent().equals(whichNpx.getParent()) ? 1 : 0) != 0);
    }
}

