/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat, Inc. All rights reserved.
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
const arrUtils_1 = require("../utils/arrUtils");
const yamlParser07_1 = require("../parser/yamlParser07");
const jsonHover_1 = require("vscode-json-languageservice/lib/umd/services/jsonHover");
class YAMLHover {
    constructor(schemaService, promiseConstructor) {
        this.promise = promiseConstructor || Promise;
        this.shouldHover = true;
        this.jsonHover = new jsonHover_1.JSONHover(schemaService, [], Promise);
    }
    configure(languageSettings) {
        if (languageSettings) {
            this.shouldHover = languageSettings.hover;
        }
    }
    doHover(document, position) {
        if (!this.shouldHover || !document) {
            return this.promise.resolve(void 0);
        }
        const doc = yamlParser07_1.parse(document.getText());
        const offset = document.offsetAt(position);
        const currentDoc = arrUtils_1.matchOffsetToDocument(offset, doc);
        if (currentDoc === null) {
            return this.promise.resolve(void 0);
        }
        const currentDocIndex = doc.documents.indexOf(currentDoc);
        currentDoc.currentDocIndex = currentDocIndex;
        return this.jsonHover.doHover(document, position, currentDoc);
    }
}
exports.YAMLHover = YAMLHover;
//# sourceMappingURL=yamlHover.js.map