/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat, Inc. All rights reserved.
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
'use strict';
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const yamlParser07_1 = require("../parser/yamlParser07");
const jsonValidation_1 = require("vscode-json-languageservice/lib/umd/services/jsonValidation");
class YAMLValidation {
    constructor(schemaService, promiseConstructor) {
        this.MATCHES_MULTIPLE = 'Matches multiple schemas when only one must validate.';
        this.promise = promiseConstructor || Promise;
        this.validationEnabled = true;
        this.jsonValidation = new jsonValidation_1.JSONValidation(schemaService, this.promise);
    }
    configure(settings) {
        if (settings) {
            this.validationEnabled = settings.validate;
            this.customTags = settings.customTags;
        }
    }
    doValidation(textDocument, isKubernetes = false) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.validationEnabled) {
                return this.promise.resolve([]);
            }
            const yamlDocument = yamlParser07_1.parse(textDocument.getText(), this.customTags);
            const validationResult = [];
            let index = 0;
            for (const currentYAMLDoc of yamlDocument.documents) {
                currentYAMLDoc.isKubernetes = isKubernetes;
                currentYAMLDoc.currentDocIndex = index;
                const validation = yield this.jsonValidation.doValidation(textDocument, currentYAMLDoc);
                const syd = currentYAMLDoc;
                if (syd.errors.length > 0) {
                    validationResult.push(...syd.errors);
                }
                if (syd.warnings.length > 0) {
                    validationResult.push(...syd.warnings);
                }
                validationResult.push(...validation);
                index++;
            }
            const foundSignatures = new Set();
            const duplicateMessagesRemoved = [];
            for (const err of validationResult) {
                /**
                 * A patch ontop of the validation that removes the
                 * 'Matches many schemas' error for kubernetes
                 * for a better user experience.
                 */
                if (isKubernetes && err.message === this.MATCHES_MULTIPLE) {
                    continue;
                }
                const errSig = err.range.start.line + ' ' + err.range.start.character + ' ' + err.message;
                if (!foundSignatures.has(errSig)) {
                    duplicateMessagesRemoved.push(err);
                    foundSignatures.add(errSig);
                }
            }
            return duplicateMessagesRemoved;
        });
    }
}
exports.YAMLValidation = YAMLValidation;
//# sourceMappingURL=yamlValidation.js.map