/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.lsp4e.operations.completion.LSContentAssistProcessor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.eclipse.wildwebdeveloper.tests.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={AllCleanRule.class})
public class TestAngular {
    @Test
    public void testAngular() throws Exception {
        IProject project = Utils.provisionTestProject("angular-app");
        Process process = new ProcessBuilder(TestAngular.getNpmLocation(), "install", "--no-bin-links", "--ignore-scripts").directory(project.getLocation().toFile()).start();
        Assertions.assertEquals((int)0, (int)process.waitFor(), (String)"npm install didn't complete property");
        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        IFolder appFolder = project.getFolder("src").getFolder("app");
        final IFile appComponentFile = appFolder.getFile("app.component.ts");
        TextEditor editor = (TextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)appComponentFile);
        DisplayHelper.sleep((long)4000L);
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        document.set(String.valueOf(document.get()) + "\n");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return Arrays.stream(appComponentFile.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0)).anyMatch(marker -> marker.getAttribute("lineNumber", -1) == 5 && marker.getAttribute("message", "").contains("template"));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 50000L), (String)"Diagnostic not published in standalone component file");
        editor.close(false);
        editor = (TextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)appFolder.getFile("app.componentWithHtml.ts"));
        DisplayHelper.sleep((long)4000L);
        final IFile appComponentHTML = appFolder.getFile("app.componentWithHtml.html");
        editor = (TextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)appComponentHTML);
        document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    IMarker[] markers = appComponentHTML.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0);
                    return Arrays.stream(markers).anyMatch(marker -> marker.getAttribute("message", "").contains("template"));
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(editor.getSite().getShell().getDisplay(), 30000L), (String)"No error found on erroneous HTML component file");
        LSContentAssistProcessor contentAssistProcessor = new LSContentAssistProcessor();
        ICompletionProposal[] proposals = contentAssistProcessor.computeCompletionProposals((ITextViewer)Utils.getViewer((AbstractTextEditor)editor), document.get().indexOf("}}"));
        proposals[0].apply(document);
        Assertions.assertEquals((Object)"<h1>{{title}}</h1>", (Object)document.get(), (String)"Incorrect completion insertion");
    }

    public static String getNpmLocation() {
        String res = "/path/to/npm";
        String[] command = new String[]{"/bin/bash", "-c", "-l", "which npm"};
        if (Platform.getOS().equals("win32")) {
            command = new String[]{"cmd", "/c", "where npm"};
        }
        BufferedReader reader = null;
        try {
            Process p = Runtime.getRuntime().exec(command);
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            res = reader.readLine();
        }
        catch (IOException e) {
            return Platform.getOS().equals("win32") ? "npm.cmd" : "npm";
        }
        if (res == null && Platform.getOS().equals("macosx")) {
            res = "/usr/local/bin/npm";
        } else if (res == null && Platform.getOS().equals("linux")) {
            res = "/usr/bin/npm";
        }
        if (res != null && Files.exists(Paths.get(res, new String[0]), new LinkOption[0])) {
            return res;
        }
        return Platform.getOS().equals("win32") ? "npm.cmd" : "npm";
    }
}

