/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestLanguageServers {
    private IProject project;

    @BeforeEach
    public void setUpProject() throws Exception {
        ScopedPreferenceStore prefs = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.lsp4e");
        prefs.putValue("org.eclipse.wildwebdeveloper.angular.file.logging.enabled", Boolean.toString(true));
        prefs.putValue("org.eclipse.wildwebdeveloper.jsts.file.logging.enabled", Boolean.toString(true));
        prefs.putValue("org.eclipse.wildwebdeveloper.css.file.logging.enabled", Boolean.toString(true));
        prefs.putValue("org.eclipse.wildwebdeveloper.html.file.logging.enabled", Boolean.toString(true));
        prefs.putValue("org.eclipse.wildwebdeveloper.json.file.logging.enabled", Boolean.toString(true));
        prefs.putValue("org.eclipse.wildwebdeveloper.xml.file.logging.enabled", Boolean.toString(true));
        prefs.putValue("org.eclipse.wildwebdeveloper.yaml.file.logging.enabled", Boolean.toString(true));
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(this.getClass().getName()) + System.nanoTime());
        this.project.create(null);
        this.project.open(null);
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference[] iViewReferenceArray = activePage.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            activePage.hideView(ref);
            ++n2;
        }
    }

    @AfterEach
    public void deleteProjectAndCloseEditors() throws Exception {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
        this.project.delete(true, null);
        DisplayHelper.sleep((long)300L);
    }

    @Test
    public void testCSSFile() throws Exception {
        final IFile file = this.project.getFile("blah.css");
        file.create((InputStream)new ByteArrayInputStream("ERROR".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("FAIL");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L), (String)"Diagnostic not published");
    }

    @Test
    public void testHTMLFile() throws Exception {
        final IFile file = this.project.getFile("blah.html");
        file.create((InputStream)new ByteArrayInputStream("FAIL".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("<style\n<html><");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L), (String)"Diagnostic not published");
    }

    @Test
    public void testYAMLFile() throws Exception {
        final IFile file = this.project.getFile("blah.yaml");
        file.create((InputStream)new ByteArrayInputStream("FAIL".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("hello: '");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L), (String)"Diagnostic not published");
    }

    @Test
    public void testJSONFile() throws Exception {
        final IFile file = this.project.getFile("blah.json");
        file.create((InputStream)new ByteArrayInputStream("FAIL".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("ERROR");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L), (String)"Diagnostic not published");
    }

    @Test
    public void testJSFile() throws Exception {
        final IFile file = this.project.getFile("blah.js");
        file.create((InputStream)new ByteArrayInputStream("ERROR".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        DisplayHelper.sleep((long)2000L);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("a<");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L), (String)"Diagnostic not published");
    }

    @Test
    public void testTSFile() throws Exception {
        final IFile file = this.project.getFile("blah.ts");
        file.create((InputStream)new ByteArrayInputStream("ERROR".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("FAIL");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L), (String)"Diagnostic not published");
    }

    @Test
    public void testJSXFile() throws Exception {
        final IFile file = this.project.getFile("blah.jsx");
        file.create((InputStream)new ByteArrayInputStream("ERROR".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("a<");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L), (String)"Diagnostic not published");
    }

    @Test
    public void testTSXFile() throws Exception {
        final IFile file = this.project.getFile("blah.tsx");
        file.create((InputStream)new ByteArrayInputStream("ERROR".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("FAIL");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L), (String)"Diagnostic not published");
    }

    @Test
    public void testResourcesPathIsntTooLong() throws Exception {
        int MAX_ALLOWED_RELATIVE_PATH = 140;
        String location = Platform.getBundle((String)"org.eclipse.wildwebdeveloper").getLocation();
        if (location.startsWith("initial@")) {
            location = location.substring("initial@".length());
        }
        if (location.startsWith("reference:")) {
            location = location.substring("reference:".length());
        }
        if (location.startsWith("file:")) {
            location = location.substring("file:".length());
        }
        File file = new File(new File(Platform.getInstallLocation().getURL().toURI()), location);
        Assertions.assertTrue((boolean)file.isDirectory());
        final TreeMap tooLongPaths = new TreeMap();
        final Path pluginPath = file.toPath();
        Files.walkFileTree(pluginPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String relativePathInsideBundle = pluginPath.relativize(dir).toString();
                if (relativePathInsideBundle.startsWith("target")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (relativePathInsideBundle.length() > 140) {
                    tooLongPaths.put(relativePathInsideBundle, relativePathInsideBundle.length());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String relativePathInsideBundle = pluginPath.relativize(file).toString();
                if (relativePathInsideBundle.length() > 140) {
                    tooLongPaths.put(relativePathInsideBundle, relativePathInsideBundle.length());
                }
                return FileVisitResult.CONTINUE;
            }
        });
        Assertions.assertEquals(Collections.emptyMap(), tooLongPaths);
    }
}

