/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={AllCleanRule.class})
public class TestYaml {
    @Test
    public void testFalseDetectionAsKubernetes() throws Exception {
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject("p");
        p.create((IProgressMonitor)new NullProgressMonitor());
        p.open((IProgressMonitor)new NullProgressMonitor());
        final IFile file = p.getFile("blah.yaml");
        file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (boolean)true);
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        document.set("name: a\ndescrition: b");
        boolean markerFound = new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0).length > 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(activePage.getWorkbenchWindow().getShell().getDisplay(), 3000L);
        Assertions.assertFalse((boolean)markerFound, (String)Arrays.stream(file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0)).map(Object::toString).collect(Collectors.joining("\n")));
    }
}

