/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={AllCleanRule.class})
public class TestESLint {
    private IProject project;

    @BeforeEach
    public void setUpProject() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(this.getClass().getName()) + System.nanoTime());
        this.project.create(null);
        this.project.open(null);
        IFile eslintConfig = this.project.getFile(".eslintrc");
        eslintConfig.create(this.getClass().getResourceAsStream("/testProjects/eslint/.eslintrc"), true, null);
        IFile tsConfig = this.project.getFile("tsconfig.json");
        tsConfig.create(this.getClass().getResourceAsStream("/testProjects/eslint/tsconfig.json"), true, null);
        IFile packageJson = this.project.getFile("package.json");
        packageJson.create(this.getClass().getResourceAsStream("/testProjects/eslint/package.json"), true, null);
        Process dependencyInstaller = new ProcessBuilder(NodeJSManager.getNpmLocation().getAbsolutePath(), "install").directory(this.project.getLocation().toFile()).start();
        Assertions.assertEquals((int)0, (int)dependencyInstaller.waitFor(), (String)"npm install didn't complete properly");
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference[] iViewReferenceArray = activePage.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            activePage.hideView(ref);
            ++n2;
        }
    }

    @Test
    public void testESLintDiagnosticsTS() throws Exception {
        final IFile file = this.project.getFile("blah.ts");
        file.create(this.getClass().getResourceAsStream("/testProjects/eslint/ESLintProj.ts"), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        DisplayHelper.sleep((long)4000L);
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L), (String)"Diagnostic not published");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0)[0].getAttribute("message", null).contains("[@typescript-eslint/explicit-function-return-type] Missing return type on function.");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L), (String)"Diagnostic content is incorrect");
    }

    @Test
    public void testESLintDiagnosticsJS() throws Exception {
        final IFile file = this.project.getFile("blah.js");
        file.create(this.getClass().getResourceAsStream("/testProjects/eslint/ESLintProj.js"), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        DisplayHelper.sleep((long)4000L);
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L), (String)"Diagnostic not published");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0)[0].getAttribute("message", null).contains("[@typescript-eslint/indent] Expected indentation of 0 spaces but found 9.");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L), (String)"Diagnostic content is incorrect");
    }
}

