"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const api_1 = require("typescript-styled-plugin/lib/api");
const embeddedSupport_1 = require("./embeddedSupport");
class NoopTemplateContext {
    constructor(typescript, text) {
        this.typescript = typescript;
        this.text = text;
        this.fileName = 'x.css';
        this.rawText = text;
    }
    get node() {
        throw new Error('Not supported');
    }
    toOffset(location) {
        let line = 0;
        let character = 0;
        for (let offset = 0;; ++offset) {
            if (line >= location.line && character >= location.character) {
                return offset;
            }
            if (this.text[offset] === '\n') {
                ++line;
                character = 0;
            }
            else {
                ++character;
            }
        }
    }
    toPosition(offset) {
        let line = 0;
        let character = 0;
        for (let i = 0; i < offset; ++i) {
            if (this.text[i] === '\n') {
                ++line;
                character = 0;
            }
            else {
                ++character;
            }
        }
        return { line, character };
    }
}
function getSubstitutions(typescript, languageService, documentProvider, templateString, spans) {
    const virtualDoc = documentProvider.createVirtualDocument(new NoopTemplateContext(typescript, templateString));
    const regions = embeddedSupport_1.getDocumentRegions(languageService, virtualDoc);
    const cssSpans = spans
        .map(span => ({ language: regions.getLanguageAtPosition(virtualDoc.positionAt(span.start)), span }))
        .filter(x => x.language === 'css')
        .map(x => x.span);
    const settings = api_1.getTemplateSettings({});
    return settings.getSubstitutions(templateString, cssSpans);
}
exports.getSubstitutions = getSubstitutions;
//# sourceMappingURL=substitutions.js.map