/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.oniguruma;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.tm4e.core.internal.oniguruma.OnigRegExp;
import org.eclipse.tm4e.core.internal.oniguruma.OnigResult;
import org.eclipse.tm4e.core.internal.oniguruma.OnigString;

public class OnigSearcher {
    private final List<OnigRegExp> regExps;

    public OnigSearcher(String[] regexps) {
        this.regExps = Arrays.stream(regexps).map(OnigRegExp::new).collect(Collectors.toList());
    }

    public OnigResult search(OnigString source, int charOffset) {
        int byteOffset = source.convertUtf16OffsetToUtf8(charOffset);
        int bestLocation = 0;
        OnigResult bestResult = null;
        int index = 0;
        for (OnigRegExp regExp : this.regExps) {
            OnigResult result = regExp.search(source, byteOffset);
            if (result != null && result.count() > 0) {
                int location = result.locationAt(0);
                if (bestResult == null || location < bestLocation) {
                    bestLocation = location;
                    bestResult = result;
                    bestResult.setIndex(index);
                }
                if (location == byteOffset) break;
            }
            ++index;
        }
        return bestResult;
    }
}

