/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class MessageLine
extends CLabel {
    public MessageLine(Composite parent) {
        this(parent, 16384);
    }

    public MessageLine(Composite parent, int style) {
        super(parent, style);
    }

    private Image findImage(IStatus status) {
        if (status.isOK()) {
            return null;
        }
        if (status.matches(4)) {
            return JFaceResources.getImage("dialog_message_error_image");
        }
        if (status.matches(2)) {
            return JFaceResources.getImage("dialog_messasge_warning_image");
        }
        if (status.matches(1)) {
            return JFaceResources.getImage("dialog_messasge_info_image");
        }
        return null;
    }

    public void setErrorStatus(IStatus status) {
        String message;
        if (status != null && (message = status.getMessage()) != null && message.length() > 0) {
            this.setText(LegacyActionTools.escapeMnemonics(message));
            this.setImage(this.findImage(status));
            return;
        }
        this.setText("");
        this.setImage(null);
    }
}

