/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.auth.UserAuth;
import org.apache.sshd.client.auth.UserAuthFactory;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.DefaultAuthFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionHolder;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.auth.UserAuthMethodFactory;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.core.CoreModuleProperties;

public class ClientUserAuthService
extends AbstractCloseable
implements Service,
ClientSessionHolder {
    protected final AtomicReference<AuthFuture> authFutureHolder = new AtomicReference();
    protected final ClientSessionImpl clientSession;
    protected final List<UserAuthFactory> authFactories;
    protected final List<String> clientMethods;
    protected List<String> serverMethods;
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private String service;
    private UserAuth userAuth;
    private int currentMethod;

    public ClientUserAuthService(Session s) {
        this.clientSession = ValidateUtils.checkInstanceOf((Object)s, ClientSessionImpl.class, "Client side service used on server side: %s", (Object)s);
        this.authFactories = ValidateUtils.checkNotNullAndNotEmpty(this.clientSession.getUserAuthFactories(), "No user auth factories for %s", s);
        this.clientMethods = new ArrayList<String>();
        String prefs = CoreModuleProperties.PREFERRED_AUTHS.getOrNull(s);
        boolean debugEnabled = this.log.isDebugEnabled();
        if (GenericUtils.isEmpty(prefs)) {
            for (UserAuthFactory factory : this.authFactories) {
                this.clientMethods.add(factory.getName());
            }
        } else {
            if (debugEnabled) {
                this.log.debug("ClientUserAuthService({}) use configured preferences: {}", (Object)s, (Object)prefs);
            }
            for (String pref : GenericUtils.split(prefs, ',')) {
                UserAuthFactory factory = NamedResource.findByName(pref, String.CASE_INSENSITIVE_ORDER, this.authFactories);
                if (factory != null) {
                    this.clientMethods.add(pref);
                    continue;
                }
                if (!debugEnabled) continue;
                this.log.debug("ClientUserAuthService({}) skip unknown preferred authentication method: {}", (Object)s, (Object)pref);
            }
        }
        if (debugEnabled) {
            this.log.debug("ClientUserAuthService({}) client methods: {}", (Object)s, this.clientMethods);
        }
        this.clientSession.resetAuthTimeout();
    }

    @Override
    public ClientSession getSession() {
        return this.getClientSession();
    }

    @Override
    public ClientSession getClientSession() {
        return this.clientSession;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public void start() {
    }

    public String getCurrentServiceName() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthFuture auth(String service) throws IOException {
        this.service = ValidateUtils.checkNotNullAndNotEmpty(service, "No service name");
        ClientSession session = this.getClientSession();
        AuthFuture authFuture = this.updateCurrentAuthFuture(session, service);
        this.serverMethods = null;
        this.currentMethod = 0;
        if (this.userAuth != null) {
            try {
                this.userAuth.destroy();
            }
            finally {
                this.userAuth = null;
            }
        }
        this.sendInitialAuthRequest(session, service);
        return authFuture;
    }

    protected AuthFuture updateCurrentAuthFuture(ClientSession session, String service) throws IOException {
        AuthFuture authFuture = this.createAuthFuture(session, service);
        AuthFuture currentFuture = this.authFutureHolder.getAndSet(authFuture);
        if (currentFuture != null) {
            if (currentFuture.isDone()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("updateCurrentAuthFuture({})[{}] request new authentication", (Object)session, (Object)service);
                }
            } else {
                currentFuture.setException(new InterruptedIOException("New authentication started before previous completed"));
            }
        }
        return authFuture;
    }

    protected AuthFuture createAuthFuture(ClientSession session, String service) throws IOException {
        return new DefaultAuthFuture(service, this.clientSession.getFutureLock());
    }

    protected IoWriteFuture sendInitialAuthRequest(ClientSession session, String service) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("auth({})[{}] send SSH_MSG_USERAUTH_REQUEST for 'none'", (Object)session, (Object)service);
        }
        String username = session.getUsername();
        Buffer buffer = session.createBuffer((byte)50, username.length() + service.length() + 32);
        buffer.putString(username);
        buffer.putString(service);
        buffer.putString("none");
        return session.writePacket(buffer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(int cmd, Buffer buffer) throws Exception {
        ClientSession session = this.getClientSession();
        AuthFuture authFuture = this.authFutureHolder.get();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (authFuture != null && authFuture.isSuccess()) {
            this.log.error("process({}) unexpected authenticated client command: {}", (Object)session, (Object)SshConstants.getCommandMessageName(cmd));
            throw new IllegalStateException("UserAuth message delivered to authenticated client");
        }
        if (authFuture != null && authFuture.isDone()) {
            if (!debugEnabled) return;
            this.log.debug("process({}) Ignoring random message - cmd={}", (Object)session, (Object)SshConstants.getCommandMessageName(cmd));
            return;
        } else if (cmd == 53) {
            String welcome = buffer.getString();
            String lang = buffer.getString();
            if (debugEnabled) {
                this.log.debug("process({}) Welcome banner(lang={}): {}", new Object[]{session, lang, welcome});
            }
            UserInteraction ui = session.getUserInteraction();
            try {
                if (ui == null || !ui.isInteractionAllowed(session)) return;
                ui.welcome(session, welcome, lang);
                return;
            }
            catch (Error e) {
                this.warn("process({}) failed ({}) to consult interaction: {}", session, e.getClass().getSimpleName(), e.getMessage(), e);
                throw new RuntimeSshException(e);
            }
        } else {
            buffer.rpos(buffer.rpos() - 1);
            this.processUserAuth(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processUserAuth(Buffer buffer) throws Exception {
        int cmd = buffer.getUByte();
        ClientSession session = this.getClientSession();
        if (cmd == 52) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("processUserAuth({}) SSH_MSG_USERAUTH_SUCCESS Succeeded with {}", (Object)session, (Object)(this.userAuth == null ? "<unknown>" : this.userAuth.getName()));
            }
            if (this.userAuth != null) {
                try {
                    this.userAuth.destroy();
                }
                finally {
                    this.userAuth = null;
                }
            }
            session.setAuthenticated();
            ((ClientSessionImpl)session).switchToNextService();
            AuthFuture authFuture = Objects.requireNonNull(this.authFutureHolder.get(), "No current future");
            authFuture.setAuthed(true);
            return;
        }
        if (cmd == 51) {
            String mths = buffer.getString();
            boolean partial = buffer.getBoolean();
            if (this.log.isDebugEnabled()) {
                this.log.debug("processUserAuth({}) Received SSH_MSG_USERAUTH_FAILURE - partial={}, methods={}", new Object[]{session, partial, mths});
            }
            if (partial || this.serverMethods == null) {
                this.serverMethods = Arrays.asList(GenericUtils.split(mths, ','));
                this.currentMethod = 0;
                if (this.userAuth != null) {
                    try {
                        this.userAuth.destroy();
                    }
                    finally {
                        this.userAuth = null;
                    }
                }
            }
            this.tryNext(cmd);
            return;
        }
        if (this.userAuth == null) {
            throw new IllegalStateException("Received unknown packet: " + SshConstants.getCommandMessageName(cmd));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("processUserAuth({}) delegate processing of {} to {}", new Object[]{session, SshConstants.getCommandMessageName(cmd), this.userAuth.getName()});
        }
        buffer.rpos(buffer.rpos() - 1);
        if (!this.userAuth.process(buffer)) {
            this.tryNext(cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryNext(int cmd) throws Exception {
        ClientSession session = this.getClientSession();
        boolean debugEnabled = this.log.isDebugEnabled();
        while (true) {
            if (this.userAuth == null) {
                if (debugEnabled) {
                    this.log.debug("tryNext({}) starting authentication mechanisms: client={}, server={}", new Object[]{session, this.clientMethods, this.serverMethods});
                }
            } else if (!this.userAuth.process(null)) {
                if (debugEnabled) {
                    this.log.debug("tryNext({}) no initial request sent by method={}", (Object)session, (Object)this.userAuth.getName());
                }
                try {
                    this.userAuth.destroy();
                }
                finally {
                    this.userAuth = null;
                }
                ++this.currentMethod;
            } else {
                if (debugEnabled) {
                    this.log.debug("tryNext({}) successfully processed initial buffer by method={}", (Object)session, (Object)this.userAuth.getName());
                }
                return;
            }
            String method = null;
            while (this.currentMethod < this.clientMethods.size() && !this.serverMethods.contains(method = this.clientMethods.get(this.currentMethod))) {
                ++this.currentMethod;
            }
            if (this.currentMethod >= this.clientMethods.size()) {
                if (debugEnabled) {
                    this.log.debug("tryNext({}) exhausted all methods - client={}, server={}", new Object[]{session, this.clientMethods, this.serverMethods});
                }
                AuthFuture authFuture = Objects.requireNonNull(this.authFutureHolder.get(), "No current future");
                authFuture.setException(new SshException(14, "No more authentication methods available"));
                return;
            }
            this.userAuth = (UserAuth)UserAuthMethodFactory.createUserAuth(session, this.authFactories, method);
            if (this.userAuth == null) {
                throw new UnsupportedOperationException("Failed to find a user-auth factory for method=" + method);
            }
            if (debugEnabled) {
                this.log.debug("tryNext({}) attempting method={}", (Object)session, (Object)method);
            }
            this.userAuth.init(session, this.service);
            debugEnabled = this.log.isDebugEnabled();
        }
    }

    @Override
    protected void preClose() {
        AuthFuture authFuture = this.authFutureHolder.get();
        if (authFuture != null && !authFuture.isDone()) {
            authFuture.setException(new SshException("Session is closed"));
        }
        super.preClose();
    }
}

