/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex.extension;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.OptionalFeature;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.common.kex.extension.parser.ServerSignatureAlgorithms;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class DefaultClientKexExtensionHandler
extends AbstractLoggingBean
implements KexExtensionHandler {
    public static final AttributeRepository.AttributeKey<Map<KexProposalOption, String>> CLIENT_PROPOSAL_KEY = new AttributeRepository.AttributeKey();
    public static final AttributeRepository.AttributeKey<Map<KexProposalOption, String>> SERVER_PROPOSAL_KEY = new AttributeRepository.AttributeKey();
    public static final NavigableSet<String> DEFAULT_EXTRA_SIGNATURES = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, new String[]{"rsa-sha2-256", "rsa-sha2-512"}));
    public static final DefaultClientKexExtensionHandler INSTANCE = new DefaultClientKexExtensionHandler();

    @Override
    public boolean isKexExtensionsAvailable(Session session, KexExtensionHandler.AvailabilityPhase phase) throws IOException {
        if (session == null || session.isServerSession()) {
            return false;
        }
        if (phase != KexExtensionHandler.AvailabilityPhase.PROPOSAL) {
            return true;
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        Map<KexProposalOption, String> clientProposal = session.getAttribute(CLIENT_PROPOSAL_KEY);
        Map<KexProposalOption, String> serverProposal = session.getAttribute(SERVER_PROPOSAL_KEY);
        if (GenericUtils.isNotEmpty(clientProposal)) {
            if (debugEnabled) {
                this.log.debug("isKexExtensionsAvailable({})[{}] already sent proposal={} (server={})", new Object[]{session, phase, clientProposal, serverProposal});
            }
            return false;
        }
        if (GenericUtils.isEmpty(serverProposal)) {
            if (debugEnabled) {
                this.log.debug("isKexExtensionsAvailable({})[{}] no server proposal", (Object)session, (Object)phase);
            }
            return false;
        }
        String algos = serverProposal.get((Object)KexProposalOption.ALGORITHMS);
        String extDeclared = Stream.of(GenericUtils.split(algos, ',')).filter(s -> "ext-info-s".equalsIgnoreCase((String)s)).findFirst().orElse(null);
        if (GenericUtils.isEmpty(extDeclared)) {
            if (debugEnabled) {
                this.log.debug("isKexExtensionsAvailable({})[{}] server proposal does not include extension indicator: {}", new Object[]{session, phase, algos});
            }
            return false;
        }
        return true;
    }

    @Override
    public void handleKexInitProposal(Session session, boolean initiator, Map<KexProposalOption, String> proposal) throws IOException {
        if (session.isServerSession()) {
            return;
        }
        session.setAttribute(initiator ? CLIENT_PROPOSAL_KEY : SERVER_PROPOSAL_KEY, new EnumMap<KexProposalOption, String>(proposal));
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleKexInitProposal({})[initiator={}] proposal={}", new Object[]{session, initiator, proposal});
        }
    }

    @Override
    public boolean handleKexExtensionRequest(Session session, int index, int count, String name, byte[] data) throws IOException {
        if (!"server-sig-algs".equalsIgnoreCase(name)) {
            return true;
        }
        Collection sigAlgos = (Collection)ServerSignatureAlgorithms.INSTANCE.parseExtension(data);
        this.updateAvailableSignatureFactories(session, sigAlgos);
        return false;
    }

    public List<NamedFactory<Signature>> updateAvailableSignatureFactories(Session session, Collection<String> extraAlgos) throws IOException {
        List<NamedFactory<Signature>> updated;
        List<NamedFactory<Signature>> available = session.getSignatureFactories();
        if (!GenericUtils.isSameReference(available, updated = this.resolveUpdatedSignatureFactories(session, available, extraAlgos))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("updateAvailableSignatureFactories({}) available={}, updated={}", new Object[]{session, available, updated});
            }
            session.setSignatureFactories(updated);
        }
        return updated;
    }

    public List<NamedFactory<Signature>> resolveUpdatedSignatureFactories(Session session, List<NamedFactory<Signature>> available, Collection<String> extraAlgos) throws IOException {
        boolean debugEnabled = this.log.isDebugEnabled();
        List<NamedFactory<Signature>> toAdd = this.resolveRequestedSignatureFactories(session, extraAlgos);
        if (GenericUtils.isEmpty(toAdd)) {
            if (debugEnabled) {
                this.log.debug("resolveUpdatedSignatureFactories({}) Nothing to add to {} out of {}", new Object[]{session, NamedResource.getNames(available), extraAlgos});
            }
            return available;
        }
        for (int index = 0; index < toAdd.size(); ++index) {
            NamedFactory<Signature> f = toAdd.get(index);
            String name = f.getName();
            NamedFactory a = available.stream().filter(s -> Objects.equals(name, s.getName())).findFirst().orElse(null);
            if (a == null) continue;
            if (debugEnabled) {
                this.log.debug("resolveUpdatedSignatureFactories({}) skip {} - already available", (Object)session, (Object)name);
            }
            toAdd.remove(index);
            --index;
        }
        return this.updateAvailableSignatureFactories(session, available, toAdd);
    }

    public List<NamedFactory<Signature>> updateAvailableSignatureFactories(Session session, List<NamedFactory<Signature>> available, Collection<? extends NamedFactory<Signature>> toAdd) throws IOException {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (GenericUtils.isEmpty(toAdd)) {
            if (debugEnabled) {
                this.log.debug("updateAvailableSignatureFactories({}) nothing to add to {}", (Object)session, (Object)NamedResource.getNames(available));
            }
            return available;
        }
        ArrayList<NamedFactory<Signature>> updated = new ArrayList<NamedFactory<Signature>>(available.size() + toAdd.size());
        updated.addAll(available);
        for (NamedFactory<Signature> namedFactory : toAdd) {
            int index = this.resolvePreferredSignaturePosition(session, updated, namedFactory);
            if (debugEnabled) {
                this.log.debug("updateAvailableSignatureFactories({}) add {} at position={}", new Object[]{session, namedFactory, index});
            }
            if (index < 0 || index >= updated.size()) {
                updated.add(namedFactory);
                continue;
            }
            updated.add(index, namedFactory);
        }
        return updated;
    }

    public int resolvePreferredSignaturePosition(Session session, List<? extends NamedFactory<Signature>> factories, NamedFactory<Signature> factory) throws IOException {
        return SignatureFactory.resolvePreferredSignaturePosition(factories, factory);
    }

    public List<NamedFactory<Signature>> resolveRequestedSignatureFactories(Session session, Collection<String> extraAlgos) throws IOException {
        if (GenericUtils.isEmpty(extraAlgos)) {
            return Collections.emptyList();
        }
        List<NamedFactory<Signature>> toAdd = Collections.emptyList();
        boolean debugEnabled = this.log.isDebugEnabled();
        for (String algo : extraAlgos) {
            NamedFactory<Signature> factory = this.resolveRequestedSignatureFactory(session, algo);
            if (factory == null) {
                if (!debugEnabled) continue;
                this.log.debug("resolveRequestedSignatureFactories({}) skip {} - no factory found", (Object)session, (Object)algo);
                continue;
            }
            if (factory instanceof OptionalFeature && !((OptionalFeature)((Object)factory)).isSupported()) {
                if (!debugEnabled) continue;
                this.log.debug("resolveRequestedSignatureFactories({}) skip {} - not supported", (Object)session, (Object)algo);
                continue;
            }
            if (toAdd.isEmpty()) {
                toAdd = new ArrayList<NamedFactory<Signature>>(extraAlgos.size());
            }
            toAdd.add(factory);
        }
        return toAdd;
    }

    public NamedFactory<Signature> resolveRequestedSignatureFactory(Session session, String name) throws IOException {
        return BuiltinSignatures.fromFactoryName(name);
    }
}

