/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.shells.dstore;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.extra.DomainEvent;
import org.eclipse.dstore.extra.IDomainListener;
import org.eclipse.rse.internal.services.dstore.shells.DStoreHostOutput;
import org.eclipse.rse.internal.services.dstore.shells.DStoreHostShell;
import org.eclipse.rse.internal.services.dstore.shells.DStoreShellOutputReader;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.model.RemoteError;
import org.eclipse.rse.subsystems.shells.core.model.RemoteOutput;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ServiceCommandShell;
import org.eclipse.swt.widgets.Shell;

public class DStoreServiceCommandShell
extends ServiceCommandShell {
    public DStoreServiceCommandShell(IRemoteCmdSubSystem cmdSS, IHostShell hostShell) {
        super(cmdSS, hostShell);
    }

    public Object getContext() {
        DStoreHostShell shell = (DStoreHostShell)this.getHostShell();
        DStoreShellOutputReader reader = (DStoreShellOutputReader)shell.getStandardOutputReader();
        String workingDir = reader.getWorkingDirectory();
        if (workingDir != null && workingDir.length() > 0) {
            try {
                IRemoteFileSubSystem ss = this.getFileSubSystem();
                if (ss.isConnected()) {
                    return ss.getRemoteFileObject(workingDir, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String getContextString() {
        DStoreHostShell shell = (DStoreHostShell)this.getHostShell();
        DStoreShellOutputReader reader = (DStoreShellOutputReader)shell.getStandardOutputReader();
        return reader.getWorkingDirectory();
    }

    private String convertSpecialCharacters(String input) {
        String converted = input.replaceAll("&#38;", "&").replaceAll("&#59;", ";");
        return converted;
    }

    public void shellOutputChanged(IHostShellChangeEvent event) {
        IHostOutput[] lines = event.getLines();
        IRemoteOutput[] outputs = new IRemoteOutput[lines.length];
        int i = 0;
        while (i < lines.length) {
            Object output = null;
            IHostOutput lineObj = lines[i];
            if (lineObj instanceof DStoreHostOutput) {
                DataElement line = ((DStoreHostOutput)lineObj).getElement();
                String type = line.getType();
                String src = line.getSource();
                output = event.isError() ? new RemoteError((Object)this, type) : new RemoteOutput((Object)this, type);
                DataStore dataStore = line.getDataStore();
                DataElement fsD = dataStore.findObjectDescriptor("directory");
                DataElement convDes = dataStore.localDescriptorQuery(fsD, "C_CHAR_CONVERSION", 1);
                String text = line.getName();
                if (convDes != null) {
                    text = this.convertSpecialCharacters(text);
                }
                output.setText(this.convertSpecialCharacters(text));
                int colonSep = src.indexOf(58);
                if (colonSep > 0) {
                    String lineNo = src.substring(colonSep + 1);
                    String file = src.substring(0, colonSep);
                    int linen = 0;
                    try {
                        linen = Integer.parseInt(lineNo);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (linen != 0) {
                        output.setAbsolutePath(file);
                        output.setLine(linen);
                    } else {
                        output.setAbsolutePath(src);
                    }
                } else {
                    output.setAbsolutePath(src);
                }
                this.addOutput(output);
                outputs[i] = output;
            }
            ++i;
        }
        this.notifyOutputChanged(outputs, false);
    }

    public boolean isActive() {
        boolean activeShell = this._hostShell.isActive();
        if (!activeShell) {
            DataElement status = ((DStoreHostShell)this._hostShell).getStatus();
            if (this._output.size() < status.getNestedSize()) {
                return true;
            }
        }
        return activeShell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutput() {
        DStoreHostShell shell = (DStoreHostShell)this.getHostShell();
        DataElement status = shell.getStatus();
        DataStore ds = status.getDataStore();
        int ssize = status.getNestedSize();
        if (ssize > 0) {
            if (!ds.isConnected()) {
                status.removeNestedData();
            } else if (status.get(ssize - 1).isSpirit() || !ds.isDoSpirit()) {
                ds.deleteObjects(status);
                ds.refresh(status);
            } else {
                CleanUpSpirited cleanUp = new CleanUpSpirited(status, this.getId());
                cleanUp.start();
            }
        }
        ArrayList arrayList = this._output;
        synchronized (arrayList) {
            this._output.clear();
        }
    }

    private class CleanUpSpirited
    extends Thread
    implements IDomainListener {
        private DataElement _status;
        private DataStore _ds;
        private boolean _done = false;
        private int _timesWaited = 0;

        public CleanUpSpirited(DataElement status, String name) {
            this._status = status;
            this._ds = status.getDataStore();
            this._ds.getDomainNotifier().addDomainListener((IDomainListener)this);
        }

        public void domainChanged(DomainEvent e) {
            this.deleteElements();
        }

        public void run() {
            while (!this._done && this._timesWaited < 3) {
                try {
                    Thread.sleep(10000L);
                    ++this._timesWaited;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.deleteElements();
            }
        }

        private void deleteElements() {
            int ssize;
            if (this._status.getNestedSize() > 0 && this._status.get((ssize = this._status.getNestedSize()) - 1).isSpirit()) {
                this._ds.deleteObjects(this._status);
                this._ds.refresh(this._status);
                this._ds.getDomainNotifier().removeDomainListener((IDomainListener)this);
                this._done = true;
            }
        }

        public Shell getShell() {
            return null;
        }

        public boolean listeningTo(DomainEvent e) {
            return e.getParent() == this._status;
        }
    }
}

