/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.settings;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.jgit.util.StringUtils;

public final class GitSettings {
    private GitSettings() {
    }

    public static int getRemoteConnectionTimeout() {
        return Platform.getPreferencesService().getInt("org.eclipse.egit.core", "core_remote_connection_timeout", 60, null);
    }

    public static Path getDefaultRepositoryDir() {
        return Paths.get(RepositoryUtil.getDefaultRepositoryDir(), new String[0]);
    }

    public static File getGpgExecutable() {
        String result = Platform.getPreferencesService().getString("org.eclipse.egit.core", "core_gpg_executable", null, null);
        if (!StringUtils.isEmptyOrNull((String)result)) {
            try {
                File exe = Paths.get(result, new String[0]).toFile();
                if (exe.isFile() && exe.canExecute()) {
                    return exe.getAbsoluteFile();
                }
                Activator.logError(MessageFormat.format(CoreText.GitSettings_gpgNotExecutable, result), null);
            }
            catch (Exception e) {
                Activator.logError(MessageFormat.format(CoreText.GitSettings_gpgInvalidExecutable, result), e);
            }
        }
        return null;
    }

    public static Collection<Path> getConfiguredRepositoryDirectories() {
        return Activator.getDefault().getRepositoryUtil().getRepositories().stream().map(string -> Paths.get(string, new String[0])).collect(Collectors.toSet());
    }

    public static void addConfiguredRepository(Path gitDir) throws IllegalArgumentException {
        Activator.getDefault().getRepositoryUtil().addConfiguredRepository(Objects.requireNonNull(gitDir).toFile());
    }
}

