/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.references;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.operations.references.LSSearchResult;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.ReferenceContext;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.LineElement;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;

public class LSSearchQuery
extends FileSearchQuery {
    private final @NonNull IDocument document;
    private final @NonNull LanguageServer languageServer;
    private final Position position;
    private final String filename;
    private LSSearchResult result;
    private long startTime;
    private CompletableFuture<List<? extends Location>> references;

    public LSSearchQuery(@NonNull IDocument document, int offset, @NonNull LanguageServer languageServer) throws BadLocationException {
        super("", false, false, null);
        this.document = document;
        this.languageServer = languageServer;
        this.position = LSPEclipseUtils.toPosition(offset, document);
        this.filename = Path.fromPortableString((String)LSPEclipseUtils.toUri(document).getPath()).lastSegment();
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.startTime = System.currentTimeMillis();
        if (this.references != null) {
            this.references.cancel(true);
        }
        AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
        textResult.removeAll();
        try {
            ReferenceParams params = new ReferenceParams();
            params.setContext(new ReferenceContext(true));
            params.setTextDocument(new TextDocumentIdentifier(LSPEclipseUtils.toUri(this.document).toString()));
            params.setPosition(this.position);
            this.languageServer.getTextDocumentService().references(params).thenAcceptAsync(locs -> {
                for (Location loc : locs) {
                    Match match = LSSearchQuery.toMatch(loc);
                    this.result.addMatch(match);
                }
            });
            return Status.OK_STATUS;
        }
        catch (Exception ex) {
            return new Status(4, LanguageServerPlugin.getDefault().getBundle().getSymbolicName(), ex.getMessage(), (Throwable)ex);
        }
    }

    private static Match toMatch(Location location) {
        try {
            IResource resource = LSPEclipseUtils.findResourceFor(location.getUri());
            IDocument document = LSPEclipseUtils.getDocument(resource);
            if (document != null) {
                int startOffset = LSPEclipseUtils.toOffset(location.getRange().getStart(), document);
                int endOffset = LSPEclipseUtils.toOffset(location.getRange().getEnd(), document);
                IRegion lineInformation = document.getLineInformationOfOffset(startOffset);
                LineElement lineEntry = new LineElement(resource, document.getLineOfOffset(startOffset), lineInformation.getOffset(), document.get(lineInformation.getOffset(), lineInformation.getLength()));
                return new FileMatch((IFile)resource, startOffset, endOffset - startOffset, lineEntry);
            }
            Position startPosition = location.getRange().getStart();
            LineElement lineEntry = new LineElement(resource, startPosition.getLine(), 0, String.format("%s:%s", startPosition.getLine(), startPosition.getCharacter()));
            return new FileMatch((IFile)resource, 0, 0, lineEntry);
        }
        catch (BadLocationException ex) {
            LanguageServerPlugin.logError(ex);
            return null;
        }
    }

    public ISearchResult getSearchResult() {
        if (this.result == null) {
            this.result = new LSSearchResult(this);
        }
        return this.result;
    }

    public String getLabel() {
        return Messages.LSSearchQuery_label;
    }

    public String getResultLabel(int nMatches) {
        long time = 0L;
        if (this.startTime > 0L) {
            time = System.currentTimeMillis() - this.startTime;
        }
        if (nMatches == 1) {
            return NLS.bind((String)Messages.LSSearchQuery_singularReference, (Object[])new Object[]{this.filename, this.position.getLine() + 1, this.position.getCharacter() + 1, time});
        }
        return NLS.bind((String)Messages.LSSearchQuery_pluralReferences, (Object[])new Object[]{this.filename, this.position.getLine() + 1, this.position.getCharacter() + 1, nMatches, time});
    }

    public boolean isFileNameSearch() {
        return false;
    }
}

