/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.wizards;

import java.util.Vector;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeListener;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.internal.files.ui.wizards.SystemNewFileWizardMainPage;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.subsystems.IVirtualRemoteFile;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.view.ISystemTree;
import org.eclipse.rse.ui.wizards.AbstractSystemWizard;

public class SystemNewFileWizard
extends AbstractSystemWizard {
    private SystemNewFileWizardMainPage mainPage;
    private static final String CLASSNAME = "SystemNewFileWizard";

    public SystemNewFileWizard() {
        super(FileResources.RESID_NEWFILE_TITLE, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.newfile_wizBannerIcon"));
    }

    public void addPages() {
        try {
            this.mainPage = this.createMainPage();
            this.addPage((IWizardPage)this.mainPage);
        }
        catch (Exception exc) {
            SystemBasePlugin.logError((String)"New File: Error in createPages: ", (Throwable)exc);
        }
    }

    protected SystemNewFileWizardMainPage createMainPage() {
        IRemoteFile[] parentFolders = null;
        SystemMessage errMsg = null;
        try {
            parentFolders = this.getParentFolders();
        }
        catch (SystemMessageException exc) {
            errMsg = exc.getSystemMessage();
        }
        this.mainPage = new SystemNewFileWizardMainPage((Wizard)this, parentFolders);
        if (errMsg != null) {
            this.mainPage.setErrorMessage(errMsg);
        }
        return this.mainPage;
    }

    public boolean performFinish() {
        boolean ok = true;
        if (this.mainPage.performFinish()) {
            SimpleSystemMessage msg = null;
            IRemoteFile parentFolder = this.mainPage.getParentFolder();
            String name = this.mainPage.getfileName();
            String absName = SystemNewFileWizard.getNewAbsoluteName(parentFolder, name);
            if (!parentFolder.exists()) {
                String msgTxt = NLS.bind((String)FileResources.FILEMSG_FOLDER_NOTFOUND, (Object)parentFolder.getAbsolutePath());
                msg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1006", 4, msgTxt);
                msg.makeSubstitution((Object)parentFolder.getAbsolutePath());
                this.mainPage.setMessage((SystemMessage)msg);
                return false;
            }
            if (this.isInputAFilter() && !this.meetsFilterCriteria(this.getSelectedFilterReference(), parentFolder, absName)) {
                return false;
            }
            String msgTxt = NLS.bind((String)FileResources.MSG_CREATEFILEGENERIC_PROGRESS, (Object)name);
            CreateNewFileJob createNewFileJob = new CreateNewFileJob(parentFolder, name, absName, msgTxt);
            createNewFileJob.schedule();
        }
        return ok;
    }

    protected static String getNewAbsoluteName(IRemoteFile parentFolder, String newName) {
        String newAbsName = null;
        char sep = parentFolder.getSeparatorChar();
        String parentFolderPath = parentFolder.getAbsolutePath();
        if (parentFolder instanceof IVirtualRemoteFile) {
            sep = '/';
        } else if (parentFolder.isArchive()) {
            sep = '/';
            parentFolderPath = String.valueOf(parentFolderPath) + "#virtual#/";
        }
        newAbsName = parentFolderPath.length() == 1 && parentFolderPath.charAt(0) == '/' && parentFolderPath.charAt(0) == sep ? String.valueOf(sep) + newName : String.valueOf(parentFolderPath) + sep + newName;
        return newAbsName;
    }

    protected boolean meetsFilterCriteria(ISystemFilterReference selectedFilterRef, IRemoteFile parentFolder, String newAbsName) {
        boolean meets;
        IRemoteFileSubSystem parentSubSystem = (IRemoteFileSubSystem)selectedFilterRef.getSubSystem();
        ISystemFilter filter = selectedFilterRef.getReferencedFilter();
        String[] strings = filter.getFilterStrings();
        if (strings != null) {
            int idx = 0;
            while (idx < strings.length) {
                if (strings[idx].equals("*")) {
                    return true;
                }
                ++idx;
            }
        }
        if (!(meets = parentSubSystem.doesFilterMatch(filter, newAbsName))) {
            String msgTxt = FileResources.FILEMSG_CREATE_RESOURCE_NOTVISIBLE;
            String msgDetails = FileResources.FILEMSG_CREATE_RESOURCE_NOTVISIBLE_DETAILS;
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1310", 4, msgTxt, msgDetails);
            SystemMessageDialog msgDlg = new SystemMessageDialog(this.getShell(), (SystemMessage)msg);
            if (msgDlg.openQuestionNoException()) {
                meets = true;
            }
        }
        return meets;
    }

    protected static void updateGUI(IRemoteFile parentFolder, IRemoteFile newFileOrFolder, Viewer viewer, boolean isInputAFilter, ISystemFilterReference selectedFilterRef) {
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        if (selectedFilterRef != null) {
            selectedFilterRef.markStale(true);
        }
        sr.invalidateFiltersFor((Object)newFileOrFolder, (ISubSystem)parentFolder.getParentRemoteFileSubSystem());
        IRemoteFileSubSystem fileSS = newFileOrFolder.getParentRemoteFileSubSystem();
        sr.fireRemoteResourceChangeEvent(1, (Object)newFileOrFolder, (Object)parentFolder, (ISubSystem)fileSS, null, (Object)viewer);
        if (isInputAFilter && viewer instanceof ISystemTree) {
            ISystemTree treeViewer = (ISystemTree)viewer;
            sr.fireEvent((ISystemResourceChangeListener)treeViewer, (ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)newFileOrFolder, 101, (Object)selectedFilterRef));
        }
    }

    protected boolean isInputAFilter() {
        return this.getInputObject() instanceof ISystemFilterReference;
    }

    protected ISystemFilterReference getSelectedFilterReference() {
        if (this.isInputAFilter()) {
            return (ISystemFilterReference)this.getInputObject();
        }
        return null;
    }

    protected IRemoteFile[] getParentFolders() throws SystemMessageException {
        Object input = this.getInputObject();
        if (input instanceof IRemoteFile) {
            return new IRemoteFile[]{(IRemoteFile)input};
        }
        if (input instanceof ISystemFilterReference) {
            return SystemNewFileWizard.getParentFolders((ISystemFilterReference)input);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRemoteFile[] getParentFolders(ISystemFilterReference filterRef) throws SystemMessageException {
        ISystemFilter filter = filterRef.getReferencedFilter();
        IRemoteFileSubSystem parentSubSystem = (IRemoteFileSubSystem)filterRef.getSubSystem();
        IRemoteFileSubSystemConfiguration parentFactory = parentSubSystem.getParentRemoteFileSubSystemConfiguration();
        String[] filterStrings = filter.getFilterStrings();
        RemoteFileFilterString rffs = null;
        Vector<IRemoteFile> v = new Vector<IRemoteFile>();
        Vector<String> uniqueNames = new Vector<String>();
        IRemoteFile folder = null;
        String pathName = null;
        SystemMessageException lastExc = null;
        int idx = 0;
        while (idx < filterStrings.length) {
            rffs = new RemoteFileFilterString(parentFactory, filterStrings[idx]);
            if (rffs.listRoots()) {
                try {
                    IRemoteFile[] roots = parentSubSystem.listRoots(null);
                    int rootIdx = 0;
                    while (roots != null && rootIdx < roots.length) {
                        if (uniqueNames.indexOf(roots[idx].getName()) == -1) {
                            v.add(roots[rootIdx]);
                        }
                        ++rootIdx;
                    }
                }
                catch (Exception roots) {}
            } else {
                pathName = rffs.getPath();
                if (uniqueNames.indexOf(pathName) == -1) {
                    uniqueNames.add(pathName);
                    try {
                        folder = parentSubSystem.getRemoteFileObject(pathName, (IProgressMonitor)new NullProgressMonitor());
                        v.add(folder);
                    }
                    catch (SystemMessageException exc) {
                        lastExc = exc;
                    }
                }
            }
            ++idx;
        }
        if (lastExc != null && v.size() == 0) {
            throw lastExc;
        }
        IRemoteFile[] folders = new IRemoteFile[v.size()];
        int idx2 = 0;
        while (idx2 < folders.length) {
            folders[idx2] = (IRemoteFile)v.elementAt(idx2);
            ++idx2;
        }
        return folders;
    }

    private class CreateNewFileJob
    extends WorkspaceJob {
        IRemoteFile parentFolder = null;
        String name = null;
        String absName = null;
        String message = null;

        public CreateNewFileJob(IRemoteFile parentFolder, String name, String absName, String message) {
            super(message);
            this.parentFolder = parentFolder;
            this.name = name;
            this.absName = absName;
            this.message = message;
            this.setUser(true);
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            boolean ok = true;
            IStatus status = Status.OK_STATUS;
            IRemoteFileSubSystem rfss = this.parentFolder.getParentRemoteFileSubSystem();
            IRemoteFile newFile = null;
            try {
                IRemoteFile newFilePath = rfss.getRemoteFileObject(this.parentFolder, this.name, monitor);
                newFile = rfss.createFile(newFilePath, monitor);
            }
            catch (RemoteFileIOException exc) {
                ok = false;
                SystemBasePlugin.logDebugMessage((String)"SystemNewFileWizard:", (String)(" Creating remote file " + this.absName + " failed with RemoteFileIOException "));
                String msgTxt = FileResources.FILEMSG_CREATE_FILE_FAILED;
                String msgDetails = FileResources.FILEMSG_CREATE_FILE_FAILED_DETAILS;
                SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1302", 4, msgTxt, msgDetails);
                SystemMessageDialog.displayErrorMessage(null, (SystemMessage)msg);
            }
            catch (RemoteFileSecurityException e) {
                ok = false;
                String msgTxt = FileResources.FILEMSG_CREATE_FILE_FAILED;
                String msgDetails = FileResources.FILEMSG_CREATE_FILE_FAILED_DETAILS;
                SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1302", 4, msgTxt, msgDetails);
                SystemBasePlugin.logDebugMessage((String)"SystemNewFileWizard:", (String)(" Creating remote file " + this.absName + " failed with RemoteFileSecurityException "));
                SystemMessageDialog.displayErrorMessage(null, (SystemMessage)msg);
            }
            catch (SystemMessageException exc) {
                ok = false;
                if (monitor.isCanceled()) {
                    status = Status.CANCEL_STATUS;
                }
                SystemMessageDialog.displayErrorMessage(null, (SystemMessage)exc.getSystemMessage());
            }
            if (ok) {
                SystemNewFileWizard.updateGUI(this.parentFolder, newFile, SystemNewFileWizard.this.getViewer(), SystemNewFileWizard.this.isInputAFilter(), SystemNewFileWizard.this.getSelectedFilterReference());
            }
            return status;
        }
    }
}

