/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.op.DiscardChangesOperation;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.util.RevCommitUtils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.selection.SelectionRepositoryStateCache;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IEvaluationService;

public abstract class ReplaceConflictActionHandler
extends RepositoryActionHandler
implements IElementUpdater {
    private final DiscardChangesOperation.Stage stage;

    protected ReplaceConflictActionHandler(DiscardChangesOperation.Stage stage) {
        this.stage = stage;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IPath[] locations = this.getSelectedLocations(event);
        if (locations == null || locations.length == 0) {
            return null;
        }
        Map pathsByRepository = ResourceUtil.splitPathsByRepository(Arrays.asList(locations));
        if (pathsByRepository.size() != 1) {
            return null;
        }
        Map.Entry entry = pathsByRepository.entrySet().iterator().next();
        Repository repository = (Repository)entry.getKey();
        IndexDiffCacheEntry indexDiff = IndexDiffCache.getInstance().getIndexDiffCacheEntry(repository);
        if (indexDiff == null) {
            return null;
        }
        IndexDiffData data = indexDiff.getIndexDiff();
        if (data == null) {
            return null;
        }
        Map conflictStates = data.getConflictStates();
        ArrayList<String> toCheckout = new ArrayList<String>();
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String path : (Collection)entry.getValue()) {
            IndexDiff.StageState state = (IndexDiff.StageState)conflictStates.get(path);
            if (IndexDiff.StageState.DELETED_BY_THEM == state && this.stage == DiscardChangesOperation.Stage.THEIRS || IndexDiff.StageState.DELETED_BY_US == state && this.stage == DiscardChangesOperation.Stage.OURS) {
                toRemove.add(path);
                continue;
            }
            toCheckout.add(path);
        }
        ReplaceConflictActionHandler.replaceWithStage(repository, this.stage, toCheckout, toRemove);
        return null;
    }

    public static void replaceWithStage(final Repository repository, final DiscardChangesOperation.Stage stage, final Collection<String> toCheckout, final Collection<String> toRemove) {
        if (toRemove.isEmpty()) {
            DiscardChangesOperation operation = new DiscardChangesOperation(repository, toCheckout);
            operation.setStage(stage);
            JobUtil.scheduleUserWorkspaceJob((IEGitOperation)operation, (String)UIText.DiscardChangesAction_discardChanges, (Object)JobFamilies.DISCARD_CHANGES);
        } else {
            IEGitOperation operation = new IEGitOperation(){

                public ISchedulingRule getSchedulingRule() {
                    return RuleUtil.getRule((Repository)repository);
                }

                public void execute(IProgressMonitor monitor) throws CoreException {
                    IWorkspaceRunnable action = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor progress) throws CoreException {
                            ResourceUtil.saveLocalHistory((Repository)repository);
                            try {
                                Throwable throwable = null;
                                Object var3_5 = null;
                                try (Git git = new Git(repository);){
                                    if (!toCheckout.isEmpty()) {
                                        CheckoutCommand checkout = git.checkout().setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer(progress));
                                        checkout.setStage(stage == DiscardChangesOperation.Stage.OURS ? CheckoutCommand.Stage.OURS : CheckoutCommand.Stage.THEIRS);
                                        for (String path : toCheckout) {
                                            checkout.addPath(path);
                                        }
                                        checkout.call();
                                    }
                                    if (!toRemove.isEmpty()) {
                                        RmCommand rm = git.rm();
                                        for (String path : toRemove) {
                                            rm.addFilepattern(path);
                                        }
                                        rm.call();
                                    }
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (GitAPIException e) {
                                throw new CoreException(Activator.createErrorStatus(e.getLocalizedMessage(), e));
                            }
                        }
                    };
                    ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, monitor);
                }
            };
            JobUtil.scheduleUserWorkspaceJob((IEGitOperation)operation, (String)UIText.DiscardChangesAction_discardChanges, (Object)JobFamilies.DISCARD_CHANGES);
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        Repository repository = SelectionUtils.getRepository(((IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class)).getCurrentState());
        if (DiscardChangesOperation.Stage.OURS == this.stage) {
            RevCommit commit = SelectionRepositoryStateCache.INSTANCE.getHeadCommit(repository);
            if (commit != null) {
                element.setText(ReplaceConflictActionHandler.formatCommitLabel(UIText.ReplaceWithOursTheirsMenu_OursWithCommitLabel, commit));
            }
        } else {
            try {
                RevCommit commit = RevCommitUtils.getTheirs((Repository)repository);
                if (commit != null) {
                    element.setText(ReplaceConflictActionHandler.formatCommitLabel(UIText.ReplaceWithOursTheirsMenu_TheirsWithCommitLabel, commit));
                }
            }
            catch (IOException e) {
                Activator.logError(e.getLocalizedMessage(), e);
            }
        }
    }

    public static String formatCommitLabel(String format, RevCommit commit) {
        String message = Utils.shortenText((String)commit.getShortMessage(), (int)60);
        return MessageFormat.format(format, Utils.getShortObjectId((ObjectId)commit), message);
    }
}

