/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit.command;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.CommitUtil;
import org.eclipse.egit.core.op.SquashCommitsOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIRepositoryUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.handler.SelectionHandler;
import org.eclipse.egit.ui.internal.rebase.CommitMessageEditorDialog;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.RebaseTodoLine;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SquashHandler
extends SelectionHandler {
    public static final String ID = "org.eclipse.egit.ui.commit.Squash";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List commits = this.getSelectedItems(RevCommit.class, event);
        if (commits == null || commits.isEmpty()) {
            return null;
        }
        Repository repo = this.getSelectedItem(Repository.class, event);
        if (repo == null) {
            return null;
        }
        commits = CommitUtil.sortCommits(commits);
        Shell shell = this.getPart(event).getSite().getShell();
        try {
            if (!UIRepositoryUtils.handleUncommittedFiles(repo, shell)) {
                return null;
            }
        }
        catch (GitAPIException e) {
            Activator.logError(e.getMessage(), e);
            return null;
        }
        RebaseCommand.InteractiveHandler messageHandler = new RebaseCommand.InteractiveHandler(){

            public void prepareSteps(List<RebaseTodoLine> steps) {
            }

            public String modifyCommitMessage(String oldMessage) {
                return SquashHandler.this.promptCommitMessage(oldMessage);
            }
        };
        final SquashCommitsOperation op = new SquashCommitsOperation(repo, commits, messageHandler);
        Job job = new Job(MessageFormat.format(UIText.SquashHandler_JobName, commits.size())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    op.execute(monitor);
                }
                catch (CoreException e) {
                    Activator.logError(UIText.SquashHandler_InternalError, e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.SQUASH.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.setRule(op.getSchedulingRule());
        job.schedule();
        return null;
    }

    private String promptCommitMessage(String message) {
        String[] msg = new String[]{message};
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            Shell shell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
            CommitMessageEditorDialog dialog = new CommitMessageEditorDialog(shell, msg[0], UIText.CommitMessageEditorDialog_OkButton, UIText.SquashHandler_EditMessageDialogCancelButton);
            if (dialog.open() == 0) {
                stringArray[0] = dialog.getCommitMessage();
            }
        });
        return msg[0];
    }
}

