/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetectorExtension;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetectorExtension2;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerExtension;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.HyperlinkDetectorDescriptor;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

public class HyperlinkSourceViewer
extends ProjectionViewer {
    private final Map<String, Color> customColors = new HashMap<String, Color>();
    private Configuration configuration;
    private Set<String> preferenceKeysForEnablement;
    private Set<String> preferenceKeysForActivation;
    private IPropertyChangeListener hyperlinkChangeListener;
    private IPropertyChangeListener editorPropertyChangeListener;
    private IPropertyChangeListener jFacePropertyChangeListener;

    public HyperlinkSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this(parent, ruler, null, false, styles);
    }

    public HyperlinkSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        this.setColors();
        this.editorPropertyChangeListener = this::handleEditorPreferencesChange;
        EditorsUI.getPreferenceStore().addPropertyChangeListener(this.editorPropertyChangeListener);
        this.jFacePropertyChangeListener = this::handleJFacePreferencesChange;
        JFacePreferences.getPreferenceStore().addPropertyChangeListener(this.jFacePropertyChangeListener);
    }

    public void configure(SourceViewerConfiguration config) {
        super.configure(config);
        if (config instanceof Configuration) {
            this.configuration = (Configuration)config;
            this.configurePreferenceKeys();
            this.hyperlinkChangeListener = event -> {
                String property = event.getProperty();
                if (this.preferenceKeysForEnablement.contains(property)) {
                    this.resetHyperlinkDetectors();
                    this.async(this::refresh);
                } else if (this.preferenceKeysForActivation.contains(property)) {
                    this.resetHyperlinkDetectors();
                }
            };
            EditorsUI.getPreferenceStore().addPropertyChangeListener(this.hyperlinkChangeListener);
        } else {
            this.configuration = null;
            this.hyperlinkChangeListener = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void handleDispose() {
        if (this.hyperlinkChangeListener != null) {
            EditorsUI.getPreferenceStore().removePropertyChangeListener(this.hyperlinkChangeListener);
            this.hyperlinkChangeListener = null;
        }
        if (this.editorPropertyChangeListener != null) {
            EditorsUI.getPreferenceStore().removePropertyChangeListener(this.editorPropertyChangeListener);
            this.editorPropertyChangeListener = null;
        }
        if (this.jFacePropertyChangeListener != null) {
            JFacePreferences.getPreferenceStore().removePropertyChangeListener(this.jFacePropertyChangeListener);
            this.jFacePropertyChangeListener = null;
        }
        try {
            super.handleDispose();
        }
        finally {
            ** for (color : this.customColors.values())
        }
lbl-1000:
        // 1 sources

        {
            if (color == null) continue;
            color.dispose();
            continue;
        }
lbl18:
        // 1 sources

        this.customColors.clear();
    }

    public void refresh() {
        this.setDocument(this.getDocument(), this.getAnnotationModel());
    }

    protected void async(Runnable runnable) {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            control.getDisplay().asyncExec(() -> {
                if (!control.isDisposed()) {
                    runnable.run();
                }
            });
        }
    }

    protected void handleEditorPreferencesChange(PropertyChangeEvent event) {
        switch (event.getProperty()) {
            case "spellingEnabled": {
                boolean isEnabled = EditorsUI.getPreferenceStore().getBoolean("spellingEnabled");
                this.updateSpellChecking(isEnabled);
                break;
            }
            case "AbstractTextEditor.Color.Foreground.SystemDefault": 
            case "AbstractTextEditor.Color.SelectionForeground.SystemDefault": 
            case "AbstractTextEditor.Color.SelectionBackground": 
            case "AbstractTextEditor.Color.Foreground": 
            case "AbstractTextEditor.Color.Background.SystemDefault": 
            case "AbstractTextEditor.Color.Background": 
            case "AbstractTextEditor.Color.SelectionBackground.SystemDefault": 
            case "AbstractTextEditor.Color.SelectionForeground": {
                this.async(this::setColors);
                break;
            }
        }
    }

    protected void handleJFacePreferencesChange(PropertyChangeEvent event) {
        if ("HYPERLINK_COLOR".equals(event.getProperty())) {
            this.async(() -> ((HyperlinkSourceViewer)this).invalidateTextPresentation());
        }
    }

    protected void setFont(Font font) {
        StyledText styledText = this.getTextWidget();
        IVerticalRuler verticalRuler = this.getVerticalRuler();
        if (this.getDocument() != null) {
            ISelectionProvider provider = this.getSelectionProvider();
            ISelection selection = provider.getSelection();
            int topIndex = this.getTopIndex();
            Control parent = this.getControl();
            parent.setRedraw(false);
            styledText.setFont(font);
            if (verticalRuler instanceof IVerticalRulerExtension) {
                IVerticalRulerExtension e = (IVerticalRulerExtension)verticalRuler;
                e.setFont(font);
            }
            provider.setSelection(selection);
            this.setTopIndex(topIndex);
            if (parent instanceof Composite) {
                Composite composite = (Composite)parent;
                composite.layout(true);
            }
            parent.setRedraw(true);
        } else {
            styledText.setFont(font);
            if (verticalRuler instanceof IVerticalRulerExtension) {
                IVerticalRulerExtension e = (IVerticalRulerExtension)verticalRuler;
                e.setFont(font);
            }
        }
    }

    private void updateSpellChecking(boolean isEnabled) {
        this.unconfigure();
        this.configure((SourceViewerConfiguration)this.configuration);
        if (!isEnabled) {
            SpellingProblem.removeAll((ISourceViewer)this, null);
        }
    }

    private void configurePreferenceKeys() {
        this.preferenceKeysForEnablement = new HashSet<String>();
        this.preferenceKeysForActivation = new HashSet<String>();
        this.preferenceKeysForEnablement.add("hyperlinksEnabled");
        this.preferenceKeysForActivation.add("hyperlinkKeyModifier");
        Set targets = this.configuration.getHyperlinkDetectorTargets((ISourceViewer)this).keySet();
        HyperlinkDetectorDescriptor[] hyperlinkDetectorDescriptorArray = EditorsUI.getHyperlinkDetectorRegistry().getHyperlinkDetectorDescriptors();
        int n = hyperlinkDetectorDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            HyperlinkDetectorDescriptor desc = hyperlinkDetectorDescriptorArray[n2];
            if (targets.contains(desc.getTargetId())) {
                this.preferenceKeysForEnablement.add(desc.getId());
                this.preferenceKeysForActivation.add(String.valueOf(desc.getId()) + "_stateMask");
            }
            ++n2;
        }
    }

    private void resetHyperlinkDetectors() {
        IHyperlinkDetector[] detectors = this.configuration.getHyperlinkDetectors((ISourceViewer)this);
        int stateMask = this.configuration.getHyperlinkStateMask((ISourceViewer)this);
        this.setHyperlinkDetectors(detectors, stateMask);
    }

    private void setColors() {
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        StyledText styledText = this.getTextWidget();
        this.setColor(styledText, store, "AbstractTextEditor.Color.Foreground", store.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault"));
        this.setColor(styledText, store, "AbstractTextEditor.Color.Background", store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault"));
        this.setColor(styledText, store, "AbstractTextEditor.Color.SelectionForeground", store.getBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault"));
        this.setColor(styledText, store, "AbstractTextEditor.Color.SelectionBackground", store.getBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault"));
    }

    private void setColor(StyledText styledText, IPreferenceStore store, String key, boolean useDefault) {
        Color newColor = useDefault ? null : this.createColor(styledText.getDisplay(), store, key);
        switch (key) {
            case "AbstractTextEditor.Color.Foreground": {
                styledText.setForeground(newColor);
                break;
            }
            case "AbstractTextEditor.Color.Background": {
                styledText.setBackground(newColor);
                break;
            }
            case "AbstractTextEditor.Color.SelectionForeground": {
                styledText.setSelectionForeground(newColor);
                break;
            }
            case "AbstractTextEditor.Color.SelectionBackground": {
                styledText.setSelectionBackground(newColor);
                break;
            }
            default: {
                return;
            }
        }
        Color oldColor = this.customColors.put(key, newColor);
        if (oldColor != null) {
            oldColor.dispose();
        }
    }

    private Color createColor(Display display, IPreferenceStore store, String key) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    public void unconfigure() {
        super.unconfigure();
        if (this.hyperlinkChangeListener != null) {
            EditorsUI.getPreferenceStore().removePropertyChangeListener(this.hyperlinkChangeListener);
            this.hyperlinkChangeListener = null;
        }
        this.preferenceKeysForEnablement = null;
        this.preferenceKeysForActivation = null;
    }

    private static int getConfiguredDefaultMask() {
        int mask = HyperlinkSourceViewer.computeStateMask(EditorsUI.getPreferenceStore().getString("hyperlinkKeyModifier"));
        if (mask == -1) {
            mask = EditorsUI.getPreferenceStore().getInt("hyperlinkKeyModifierMask");
        }
        return mask;
    }

    private static final int findLocalizedModifier(String modifierName) {
        if (modifierName == null) {
            return 0;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    private static final int computeStateMask(String modifiers) {
        if (modifiers == null) {
            return -1;
        }
        if (modifiers.length() == 0) {
            return 0;
        }
        int stateMask = 0;
        StringTokenizer modifierTokenizer = new StringTokenizer(modifiers, ",;.:+-* ");
        while (modifierTokenizer.hasMoreTokens()) {
            int modifier = HyperlinkSourceViewer.findLocalizedModifier(modifierTokenizer.nextToken());
            if (modifier == 0 || (stateMask & modifier) == modifier) {
                return -1;
            }
            stateMask |= modifier;
        }
        return stateMask;
    }

    public static class Configuration
    extends TextSourceViewerConfiguration {
        public Configuration() {
        }

        public Configuration(IPreferenceStore preferenceStore) {
            super(preferenceStore);
        }

        public final IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
            IHyperlinkDetector[] detectors = this.internalGetHyperlinkDetectors(sourceViewer);
            if (detectors != null && detectors.length > 0 && this.getHyperlinkStateMask(sourceViewer) == 0) {
                int defaultMask = HyperlinkSourceViewer.getConfiguredDefaultMask();
                IHyperlinkDetector[] newDetectors = new IHyperlinkDetector[detectors.length * 2];
                int j = 0;
                IHyperlinkDetector[] iHyperlinkDetectorArray = detectors;
                int n = detectors.length;
                int n2 = 0;
                while (n2 < n) {
                    IHyperlinkDetector original = iHyperlinkDetectorArray[n2];
                    if (original instanceof IHyperlinkDetectorExtension2) {
                        int mask = ((IHyperlinkDetectorExtension2)original).getStateMask();
                        if (mask == -1) {
                            newDetectors[j++] = new FixedMaskHyperlinkDetector(original, defaultMask);
                            if (defaultMask != 0) {
                                newDetectors[j++] = new NoMaskHyperlinkDetector(original);
                            }
                        } else {
                            newDetectors[j++] = original;
                            if (mask != 0) {
                                newDetectors[j++] = new NoMaskHyperlinkDetector(original);
                            }
                        }
                    } else {
                        newDetectors[j++] = original;
                    }
                    ++n2;
                }
                IHyperlinkDetector[] result = new IHyperlinkDetector[j];
                System.arraycopy(newDetectors, 0, result, 0, j);
                return result;
            }
            return detectors;
        }

        @Nullable
        protected IHyperlinkDetector[] internalGetHyperlinkDetectors(ISourceViewer sourceViewer) {
            return super.getHyperlinkDetectors(sourceViewer);
        }

        protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
            return super.getHyperlinkDetectorTargets(sourceViewer);
        }
    }

    private static class FixedMaskHyperlinkDetector
    extends InternalHyperlinkDetector {
        private final int mask;

        protected FixedMaskHyperlinkDetector(IHyperlinkDetector delegate, int mask) {
            super(delegate);
            this.mask = mask;
        }

        public int getStateMask() {
            return this.mask;
        }
    }

    private static abstract class InternalHyperlinkDetector
    implements IHyperlinkDetector,
    IHyperlinkDetectorExtension,
    IHyperlinkDetectorExtension2 {
        protected IHyperlinkDetector delegate;

        protected InternalHyperlinkDetector(IHyperlinkDetector delegate) {
            this.delegate = delegate;
        }

        public final IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
            return this.delegate.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks);
        }

        public final void dispose() {
            if (this.delegate instanceof IHyperlinkDetectorExtension) {
                ((IHyperlinkDetectorExtension)this.delegate).dispose();
            }
        }
    }

    protected static class NoMaskHyperlinkDetector
    extends FixedMaskHyperlinkDetector {
        private NoMaskHyperlinkDetector(IHyperlinkDetector delegate) {
            super(delegate, 0);
        }
    }
}

