/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.debug.AbstractDebugAdapterLaunchShortcut;
import org.eclipse.wildwebdeveloper.debug.Messages;
import org.eclipse.wildwebdeveloper.debug.SelectionUtils;
import org.eclipse.wildwebdeveloper.debug.chrome.ChromeRunDebugLaunchShortcut;

public abstract class AbstractRunHTMLDebugTab
extends AbstractLaunchConfigurationTab {
    private Text programPathText;
    private Text argumentsText;
    private Text workingDirectoryText;
    protected Composite resComposite;
    private Text urlText;
    protected AbstractDebugAdapterLaunchShortcut shortcut = new ChromeRunDebugLaunchShortcut();
    private Button filePath;
    private ControlDecoration decoration;
    private Button fileRadio;
    private Button urlRadio;

    public void createControl(Composite parent) {
        this.resComposite = new Composite(parent, 0);
        this.resComposite.setLayout((Layout)new GridLayout(3, false));
        this.fileRadio = this.createRadioButton(this.resComposite, Messages.FirefoxDebugTab_File);
        this.fileRadio.setToolTipText(Messages.AbstractRunHTMLDebugTab_fileRadioToolTip);
        this.fileRadio.setLayoutData((Object)new GridData(-1, -1, false, false));
        this.fileRadio.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.urlText.setEnabled(false);
            this.programPathText.setEnabled(true);
            this.filePath.setEnabled(true);
            this.validateProgramPath();
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }));
        this.programPathText = new Text(this.resComposite, 2048);
        this.programPathText.setLayoutData((Object)new GridData(4, -1, true, false));
        this.decoration = new ControlDecoration((Control)this.programPathText, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.decoration.setImage(fieldDecoration.getImage());
        this.programPathText.addModifyListener(event -> this.validateProgramPath());
        this.filePath = new Button(this.resComposite, 8);
        this.filePath.setText(Messages.AbstractRunHTMLDebugTab_browse);
        this.filePath.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog filePathDialog = new FileDialog(this.resComposite.getShell());
            filePathDialog.setFilterPath(this.workingDirectoryText.getText());
            filePathDialog.setText("Select a .html file to debug");
            String path = filePathDialog.open();
            if (path != null) {
                this.programPathText.setText(path);
                this.setDirty(true);
                this.updateLaunchConfigurationDialog();
            }
        }));
        this.urlRadio = this.createRadioButton(this.resComposite, "URL: ");
        this.urlRadio.setToolTipText(Messages.RunFirefoxDebugTab_URL_Note);
        this.urlRadio.setLayoutData((Object)new GridData(-1, -1, false, false));
        this.urlRadio.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.programPathText.setEnabled(false);
            this.filePath.setEnabled(false);
            this.urlText.setEnabled(true);
            this.decoration.hide();
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }));
        this.urlText = new Text(this.resComposite, 2048);
        GridData urlTextGD = new GridData(4, -1, true, false);
        urlTextGD.horizontalSpan = 2;
        this.urlText.setLayoutData((Object)urlTextGD);
        this.urlText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        new Label(this.resComposite, 0).setText(Messages.RunProgramTab_argument);
        this.argumentsText = new Text(this.resComposite, 2048);
        GridData argsGD = new GridData(4, -1, true, false);
        argsGD.horizontalSpan = 2;
        this.argumentsText.setLayoutData((Object)argsGD);
        this.argumentsText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        new Label(this.resComposite, 0).setText(Messages.RunProgramTab_workingDirectory);
        this.workingDirectoryText = new Text(this.resComposite, 2048);
        this.workingDirectoryText.setLayoutData((Object)new GridData(4, -1, true, false));
        this.workingDirectoryText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        Button workingDirectoryButton = new Button(this.resComposite, 8);
        workingDirectoryButton.setText(Messages.AbstractRunHTMLDebugTab_browse);
        workingDirectoryButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            DirectoryDialog workingDirectoryDialog = new DirectoryDialog(this.resComposite.getShell());
            workingDirectoryDialog.setFilterPath(this.workingDirectoryText.getText());
            workingDirectoryDialog.setText("Select folder to watch for changes");
            String path = workingDirectoryDialog.open();
            if (path != null) {
                this.workingDirectoryText.setText(path);
                this.setDirty(true);
                this.updateLaunchConfigurationDialog();
            }
        }));
        this.setControl((Control)this.resComposite);
    }

    private void validateProgramPath() {
        this.setDirty(true);
        File file = new File(this.programPathText.getText());
        if (!file.isFile()) {
            String errorMessage = Messages.RunProgramTab_error_unknownFile;
            this.setErrorMessage(errorMessage);
            this.decoration.setDescriptionText(errorMessage);
            this.decoration.show();
        } else if (!this.shortcut.canLaunch(file)) {
            String errorMessage = "Not a html file";
            this.setErrorMessage(errorMessage);
            this.decoration.setDescriptionText(errorMessage);
            this.decoration.show();
        } else if (!file.canRead()) {
            String errorMessage = Messages.RunProgramTab_error_nonReadableFile;
            this.setErrorMessage(errorMessage);
            this.decoration.setDescriptionText(errorMessage);
            this.decoration.show();
        } else {
            this.setErrorMessage(null);
            this.decoration.hide();
        }
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String defaultSelectedFile = SelectionUtils.pathOrEmpty(SelectionUtils.getSelectedFile(this.shortcut::canLaunch));
            this.programPathText.setText(configuration.getAttribute("program", defaultSelectedFile));
            this.argumentsText.setText(configuration.getAttribute("runtimeArgs", ""));
            this.workingDirectoryText.setText(configuration.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", SelectionUtils.pathOrEmpty(SelectionUtils.getSelectedProject())));
            this.urlText.setText(configuration.getAttribute("url", ""));
            if (this.urlText.getText().isEmpty()) {
                this.fileRadio.setSelection(true);
                this.urlText.setEnabled(false);
            } else {
                this.programPathText.setEnabled(false);
                this.filePath.setEnabled(false);
                this.urlText.setEnabled(true);
                this.urlRadio.setSelection(true);
                this.decoration.hide();
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String programPath = this.programPathText.getText();
        if (this.programPathText.isEnabled()) {
            configuration.setAttribute("program", programPath);
            configuration.setAttribute("url", "");
        } else if (this.urlText.isEnabled()) {
            configuration.setAttribute("url", this.urlText.getText());
            configuration.setAttribute("program", "");
        }
        configuration.setAttribute("runtimeArgs", this.argumentsText.getText());
        String workingDirectory = this.workingDirectoryText.getText();
        configuration.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", workingDirectory);
        configuration.setMappedResources((IResource[])ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(new File(programPath).toURI()));
    }

    public String getName() {
        return Messages.RunProgramTab_title;
    }
}

