/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.text;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.CursorLinePainter;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.PaintManager;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm4e.core.TMException;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.logger.ILogger;
import org.eclipse.tm4e.core.model.IModelTokensChangedListener;
import org.eclipse.tm4e.core.model.ITMModel;
import org.eclipse.tm4e.core.model.ModelTokensChangedEvent;
import org.eclipse.tm4e.core.model.Range;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.registry.EclipseSystemLogger;
import org.eclipse.tm4e.registry.TMEclipseRegistryPlugin;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.TMUIMessages;
import org.eclipse.tm4e.ui.internal.model.DocumentHelper;
import org.eclipse.tm4e.ui.internal.model.TMDocumentModel;
import org.eclipse.tm4e.ui.internal.text.TMPresentationReconcilerTestGenerator;
import org.eclipse.tm4e.ui.internal.themes.ThemeManager;
import org.eclipse.tm4e.ui.internal.wizards.TextMateGrammarImportWizard;
import org.eclipse.tm4e.ui.model.ITMModelManager;
import org.eclipse.tm4e.ui.text.ITMPresentationReconcilerListener;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.IThemeManager;
import org.eclipse.tm4e.ui.themes.ITokenProvider;
import org.eclipse.tm4e.ui.utils.ClassHelper;
import org.eclipse.tm4e.ui.utils.ContentTypeHelper;
import org.eclipse.tm4e.ui.utils.ContentTypeInfo;
import org.eclipse.tm4e.ui.utils.PreferenceUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class TMPresentationReconciler
implements IPresentationReconciler {
    private static boolean GENERATE_TEST = TMEclipseRegistryPlugin.isDebugOptionEnabled((String)"org.eclipse.tm4e.ui/debug/log/GenerateTest");
    private static boolean THROW_ERROR = TMEclipseRegistryPlugin.isDebugOptionEnabled((String)"org.eclipse.tm4e.ui/debug/log/ThrowError");
    private static final ILogger RECONCILER_LOGGER = new EclipseSystemLogger("org.eclipse.tm4e.ui/debug/log/TMPresentationReconciler");
    private final Token defaultToken = new Token(null);
    private ITextViewer viewer;
    private final InternalListener internalListener = new InternalListener();
    private IGrammar grammar;
    private boolean forcedGrammar;
    private ITokenProvider tokenProvider;
    private boolean forcedTheme;
    private final TextAttribute fDefaultTextAttribute = new TextAttribute(null);
    private IEclipsePreferences.IPreferenceChangeListener themeChangeListener;
    private List<ITMPresentationReconcilerListener> listeners = null;
    private ILogger logger;
    private boolean initializeViewerColors;
    private boolean updateTextDecorations;
    private boolean openImportDialogWhenGrammarNotFound;
    private boolean enabled;
    private boolean throwError;

    public TMPresentationReconciler() {
        if (GENERATE_TEST) {
            this.addTMPresentationReconcilerListener(new TMPresentationReconcilerTestGenerator());
        }
        this.setThrowError(THROW_ERROR);
    }

    public void setGrammar(IGrammar grammar) {
        boolean changed = this.viewer != null && (this.grammar == null || !this.grammar.equals(grammar));
        this.grammar = grammar;
        this.forcedGrammar = true;
        if (changed) {
            IDocument document = this.viewer.getDocument();
            if (document == null) {
                return;
            }
            this.internalListener.inputDocumentAboutToBeChanged(this.viewer.getDocument(), null);
            this.internalListener.inputDocumentChanged(null, document);
        }
    }

    public IGrammar getGrammar() {
        return this.grammar;
    }

    public ITokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public void setTokenProvider(ITokenProvider tokenProvider) {
        IGrammar grammar;
        ITokenProvider oldTheme = this.tokenProvider;
        ITokenProvider newTheme = tokenProvider;
        boolean changed = oldTheme == null || !oldTheme.equals(newTheme);
        this.tokenProvider = tokenProvider;
        this.forcedTheme = true;
        if (changed && (grammar = this.grammar) != null) {
            this.themeChange(oldTheme, newTheme, this.viewer.getDocument());
        }
    }

    public void setThemeId(String themeId) {
        this.setTokenProvider(TMUIPlugin.getThemeManager().getThemeById(themeId));
    }

    private void themeChange(ITokenProvider oldTheme, ITokenProvider newTheme, IDocument document) {
        if (newTheme != null && !newTheme.equals(oldTheme)) {
            this.tokenProvider = newTheme;
            this.applyThemeEditor();
            ITMModel model = this.getTMModelManager().connect(document);
            this.colorize(0, document.getNumberOfLines() - 1, null, (TMDocumentModel)model);
        }
    }

    public void install(ITextViewer viewer) {
        Assert.isNotNull((Object)viewer);
        this.viewer = viewer;
        viewer.addTextInputListener((ITextInputListener)this.internalListener);
        IDocument document = viewer.getDocument();
        if (document != null) {
            this.internalListener.inputDocumentChanged(null, document);
        }
        this.themeChangeListener = new ThemeChangeListener();
        ThemeManager.getInstance().addPreferenceChangeListener(this.themeChangeListener);
    }

    public void uninstall() {
        this.viewer.removeTextInputListener((ITextInputListener)this.internalListener);
        this.internalListener.inputDocumentAboutToBeChanged(this.viewer.getDocument(), null);
        if (this.themeChangeListener != null) {
            ThemeManager.getInstance().removePreferenceChangeListener(this.themeChangeListener);
        }
        this.themeChangeListener = null;
    }

    public IPresentationDamager getDamager(String contentType) {
        return null;
    }

    public IPresentationRepairer getRepairer(String contentType) {
        return null;
    }

    private ITMModelManager getTMModelManager() {
        return TMUIPlugin.getTMModelManager();
    }

    private void colorize(ModelTokensChangedEvent e) {
        for (Range range : e.getRanges()) {
            this.colorize(range.fromLineNumber - 1, range.toLineNumber - 1, null, (TMDocumentModel)e.getModel());
        }
    }

    private void colorize(int fromLineNumber, int toLineNumber, IRegion damage, TMDocumentModel model) {
        block14: {
            this.applyThemeEditorIfNeeded();
            ILogger logger = this.getLogger();
            if (logger.isEnabled()) {
                logger.log("Render from: " + fromLineNumber + " to: " + toLineNumber);
            }
            TextPresentation presentation = null;
            Throwable error = null;
            try {
                try {
                    IDocument document = model.getDocument();
                    presentation = new TextPresentation(damage != null ? damage : DocumentHelper.getRegion(document, fromLineNumber, toLineNumber), 1000);
                    int lastStart = presentation.getExtent().getOffset();
                    int length = 0;
                    boolean firstToken = true;
                    IToken lastToken = Token.UNDEFINED;
                    TextAttribute lastAttribute = this.getTokenTextAttribute(lastToken);
                    List tokens = null;
                    int line = fromLineNumber;
                    while (line <= toLineNumber) {
                        tokens = model.getLineTokens(line);
                        if (tokens == null) {
                            if (!logger.isEnabled()) break;
                            logger.log("TextMate tokens not available for line " + line);
                            break;
                        }
                        int startLineOffset = document.getLineOffset(line);
                        int i = 0;
                        while (i < tokens.size()) {
                            block18: {
                                IToken token;
                                int tokenStartIndex;
                                TMToken nextToken;
                                TMToken currentToken;
                                block15: {
                                    block16: {
                                        block17: {
                                            currentToken = (TMToken)tokens.get(i);
                                            nextToken = i + 1 < tokens.size() ? (TMToken)tokens.get(i + 1) : null;
                                            tokenStartIndex = currentToken.startIndex;
                                            if (damage == null) break block15;
                                            if (!this.isBeforeRegion(currentToken, startLineOffset, damage)) break block16;
                                            if (nextToken == null) break block17;
                                            if (this.isBeforeRegion(nextToken, startLineOffset, damage)) break block18;
                                            tokenStartIndex = damage.getOffset() - startLineOffset;
                                            break block15;
                                        }
                                        tokenStartIndex = damage.getOffset() - startLineOffset;
                                        token = this.toToken(currentToken);
                                        lastAttribute = this.getTokenTextAttribute(token);
                                        length += this.getTokenLengh(tokenStartIndex, nextToken, line, document);
                                        firstToken = false;
                                        break block18;
                                    }
                                    if (this.isAfterRegion(currentToken, startLineOffset, damage)) break;
                                }
                                token = this.toToken(currentToken);
                                TextAttribute attribute = this.getTokenTextAttribute(token);
                                if (lastAttribute != null && lastAttribute.equals((Object)attribute)) {
                                    length += this.getTokenLengh(tokenStartIndex, nextToken, line, document);
                                    firstToken = false;
                                } else {
                                    if (!firstToken) {
                                        this.addRange(presentation, lastStart, length, lastAttribute);
                                    }
                                    firstToken = false;
                                    lastToken = token;
                                    lastAttribute = attribute;
                                    lastStart = tokenStartIndex + startLineOffset;
                                    length = this.getTokenLengh(tokenStartIndex, nextToken, line, document);
                                }
                            }
                            ++i;
                        }
                        ++line;
                    }
                    if (damage != null) {
                        length = Math.min(length, damage.getOffset() + damage.getLength() - lastStart);
                    }
                    this.addRange(presentation, lastStart, length, lastAttribute);
                    this.applyTextRegionCollection(presentation);
                }
                catch (Throwable e) {
                    error = e;
                    if (logger.isEnabled()) {
                        logger.log("Error while rendering from: " + fromLineNumber + " to: " + toLineNumber, e);
                    }
                    this.fireColorize(presentation, error);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                this.fireColorize(presentation, error);
                throw throwable;
            }
            this.fireColorize(presentation, error);
        }
    }

    private boolean isBeforeRegion(TMToken token, int startLineOffset, IRegion damage) {
        return token.startIndex + startLineOffset < damage.getOffset();
    }

    private boolean isAfterRegion(TMToken t, int startLineOffset, IRegion damage) {
        return t.startIndex + startLineOffset >= damage.getOffset() + damage.getLength();
    }

    private IToken toToken(TMToken t) {
        IToken token = this.getTokenProvider().getToken(t.type);
        if (token != null) {
            return token;
        }
        return this.defaultToken;
    }

    private int getTokenLengh(int tokenStartIndex, TMToken nextToken, int line, IDocument document) throws BadLocationException {
        if (nextToken != null) {
            return nextToken.startIndex - tokenStartIndex;
        }
        return document.getLineLength(line) - tokenStartIndex;
    }

    protected TextAttribute getTokenTextAttribute(IToken token) {
        Object data = token.getData();
        if (data instanceof TextAttribute) {
            return (TextAttribute)data;
        }
        return this.fDefaultTextAttribute;
    }

    protected void addRange(TextPresentation presentation, int offset, int length, TextAttribute attr) {
        if (attr != null) {
            int style = attr.getStyle();
            int fontStyle = style & 3;
            StyleRange styleRange = new StyleRange(offset, length, attr.getForeground(), attr.getBackground(), fontStyle);
            styleRange.strikeout = (style & 0x20000000) != 0;
            styleRange.underline = (style & 0x40000000) != 0;
            styleRange.font = attr.getFont();
            presentation.addStyleRange(styleRange);
        }
    }

    private void applyTextRegionCollection(TextPresentation presentation) {
        this.viewer.changeTextPresentation(presentation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTMPresentationReconcilerListener(ITMPresentationReconcilerListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ITMPresentationReconcilerListener>();
        }
        List<ITMPresentationReconcilerListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTMPresentationReconcilerListener(ITMPresentationReconcilerListener listener) {
        if (this.listeners == null) {
            return;
        }
        List<ITMPresentationReconcilerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInstall(ITextViewer viewer, IDocument document) {
        if (this.listeners == null) {
            return;
        }
        List<ITMPresentationReconcilerListener> list = this.listeners;
        synchronized (list) {
            for (ITMPresentationReconcilerListener listener : this.listeners) {
                listener.install(viewer, document);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireUninstall() {
        if (this.listeners == null) {
            return;
        }
        List<ITMPresentationReconcilerListener> list = this.listeners;
        synchronized (list) {
            for (ITMPresentationReconcilerListener listener : this.listeners) {
                listener.uninstall();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireColorize(TextPresentation presentation, Throwable error) {
        if (this.listeners == null) {
            return;
        }
        List<ITMPresentationReconcilerListener> list = this.listeners;
        synchronized (list) {
            for (ITMPresentationReconcilerListener listener : this.listeners) {
                listener.colorize(presentation, error);
            }
        }
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public ILogger getLogger() {
        if (this.logger == null) {
            return RECONCILER_LOGGER;
        }
        return this.logger;
    }

    public static TMPresentationReconciler getTMPresentationReconciler(IEditorPart editorPart) {
        ITextOperationTarget target = (ITextOperationTarget)editorPart.getAdapter(ITextOperationTarget.class);
        if (target instanceof ITextViewer) {
            ITextViewer textViewer = (ITextViewer)target;
            return TMPresentationReconciler.getTMPresentationReconciler(textViewer);
        }
        return null;
    }

    public static TMPresentationReconciler getTMPresentationReconciler(ITextViewer textViewer) {
        try {
            Field field = SourceViewer.class.getDeclaredField("fPresentationReconciler");
            if (field != null) {
                field.setAccessible(true);
                IPresentationReconciler presentationReconciler = (IPresentationReconciler)field.get(textViewer);
                return presentationReconciler instanceof TMPresentationReconciler ? (TMPresentationReconciler)presentationReconciler : null;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private void applyThemeEditor() {
        this.initializeViewerColors = false;
        this.updateTextDecorations = false;
        this.applyThemeEditorIfNeeded();
    }

    private void applyThemeEditorIfNeeded() {
        if (!this.initializeViewerColors) {
            StyledText styledText = this.viewer.getTextWidget();
            ((ITheme)this.tokenProvider).initializeViewerColors(styledText);
            this.initializeViewerColors = true;
        }
        if (!this.updateTextDecorations) {
            try {
                List painters;
                PaintManager paintManager = (PaintManager)ClassHelper.getFieldValue(this.viewer, "fPaintManager", TextViewer.class);
                if (paintManager != null && (painters = (List)ClassHelper.getFieldValue(paintManager, "fPainters", PaintManager.class)) != null) {
                    for (IPainter painter : painters) {
                        if (!(painter instanceof CursorLinePainter)) continue;
                        Color background = this.tokenProvider.getEditorCurrentLineHighlight();
                        if (background != null) {
                            ((CursorLinePainter)painter).setHighlightColor(background);
                        }
                        this.updateTextDecorations = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setOpenImportDialogWhenGrammarNotFound(boolean openImportDialogWhenGrammarNotFound) {
        this.openImportDialogWhenGrammarNotFound = openImportDialogWhenGrammarNotFound;
    }

    public boolean isOpenImportDialogWhenGrammarNotFound() {
        return this.openImportDialogWhenGrammarNotFound;
    }

    public void setThrowError(boolean throwError) {
        this.throwError = throwError;
    }

    public boolean isThrowError() {
        return this.throwError;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    class InternalListener
    implements ITextInputListener,
    IModelTokensChangedListener,
    ITextListener {
        InternalListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldDocument, IDocument newDocument) {
            if (oldDocument != null) {
                TMPresentationReconciler.this.viewer.removeTextListener((ITextListener)this);
                TMPresentationReconciler.this.getTMModelManager().disconnect(oldDocument);
                TMPresentationReconciler.this.fireUninstall();
            }
        }

        public void inputDocumentChanged(IDocument oldDocument, IDocument newDocument) {
            block13: {
                if (newDocument != null) {
                    TMPresentationReconciler.this.fireInstall(TMPresentationReconciler.this.viewer, newDocument);
                    try {
                        TextMateGrammarImportWizard wizard;
                        WizardDialog dialog;
                        Shell activeShell;
                        ContentTypeInfo info;
                        IGrammar grammar;
                        TMPresentationReconciler.this.viewer.addTextListener((ITextListener)this);
                        IGrammar iGrammar = grammar = TMPresentationReconciler.this.forcedGrammar ? TMPresentationReconciler.this.grammar : null;
                        if (grammar == null && (info = ContentTypeHelper.findContentTypes(newDocument)) != null && (grammar = this.findGrammar(info)) == null && TMPresentationReconciler.this.isOpenImportDialogWhenGrammarNotFound() && MessageDialog.openConfirm((Shell)(activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()), (String)TMUIMessages.TMPresentationReconciler_register_dialog_title, (String)NLS.bind((String)TMUIMessages.TMPresentationReconciler_register_dialog_message, (Object)info.getFileName())) && (dialog = new WizardDialog(activeShell, (IWizard)(wizard = new TextMateGrammarImportWizard()))).open() == 0) {
                            grammar = this.findGrammar(info);
                        }
                        if (grammar != null) {
                            TMPresentationReconciler.this.grammar = grammar;
                        } else if (TMPresentationReconciler.this.isThrowError()) {
                            throw new TMException("Cannot find TextMate grammar for the given document");
                        }
                        if (grammar != null) {
                            String scopeName = grammar.getScopeName();
                            if (TMPresentationReconciler.this.tokenProvider == null) {
                                TMPresentationReconciler.this.tokenProvider = TMUIPlugin.getThemeManager().getThemeForScope(scopeName);
                            }
                            if (TMPresentationReconciler.this.tokenProvider != null) {
                                TMPresentationReconciler.this.applyThemeEditor();
                            } else if (TMPresentationReconciler.this.isThrowError()) {
                                throw new TMException("Cannot find Theme for the given grammar '" + scopeName + "'");
                            }
                        }
                        boolean bl = grammar != null && TMPresentationReconciler.this.tokenProvider != null;
                        TMPresentationReconciler.this.enabled = bl;
                        boolean enable = bl;
                        if (enable) {
                            ITMModel model = TMPresentationReconciler.this.getTMModelManager().connect(newDocument);
                            model.setGrammar(grammar);
                            model.addModelTokensChangedListener((IModelTokensChangedListener)this);
                        }
                    }
                    catch (CoreException e) {
                        if (!TMPresentationReconciler.this.logger.isEnabled()) break block13;
                        TMPresentationReconciler.this.logger.log("Error while initializing TextMate model.", (Throwable)e);
                    }
                }
            }
        }

        private IGrammar findGrammar(ContentTypeInfo info) {
            String fileName;
            IContentType[] contentTypes = info.getContentTypes();
            IGrammar grammar = TMEclipseRegistryPlugin.getGrammarRegistryManager().getGrammarFor(contentTypes);
            if (grammar == null && (fileName = info.getFileName()) != null) {
                String fileType = new Path(fileName).getFileExtension();
                grammar = TMEclipseRegistryPlugin.getGrammarRegistryManager().getGrammarForFileType(fileType);
            }
            return grammar;
        }

        public void textChanged(TextEvent e) {
            if (!e.getViewerRedrawState()) {
                return;
            }
            if (e.getDocumentEvent() != null) {
                StyleRange range;
                int diff = e.getText().length() - e.getLength();
                if (diff > 0 && e.getOffset() > 0 && (range = TMPresentationReconciler.this.viewer.getTextWidget().getStyleRangeAtOffset(e.getOffset() - 1)) != null) {
                    range.length += diff;
                    TMPresentationReconciler.this.viewer.getTextWidget().setStyleRange(range);
                }
            } else {
                IDocument document = TMPresentationReconciler.this.viewer.getDocument();
                if (document != null) {
                    IRegion region = null;
                    int fromLineNumber = -1;
                    int toLineNumber = -1;
                    if (e.getOffset() == 0 && e.getLength() == 0 && e.getText() == null) {
                        fromLineNumber = 0;
                        toLineNumber = document.getNumberOfLines() - 1;
                    } else {
                        region = this.widgetRegion2ModelRegion(e);
                        if (region != null) {
                            if (region.getLength() == 0) {
                                return;
                            }
                            try {
                                String text = document.get(region.getOffset(), region.getLength());
                                DocumentEvent de = new DocumentEvent(document, region.getOffset(), region.getLength(), text);
                                fromLineNumber = DocumentHelper.getStartLine(de);
                                toLineNumber = DocumentHelper.getEndLine(de, false);
                            }
                            catch (BadLocationException badLocationException) {}
                        }
                    }
                    if (TMPresentationReconciler.this.enabled) {
                        ITMModel model = TMPresentationReconciler.this.getTMModelManager().connect(document);
                        TMPresentationReconciler.this.colorize(fromLineNumber, toLineNumber, region, (TMDocumentModel)model);
                    } else if (region != null) {
                        TextPresentation presentation = new TextPresentation(region, 100);
                        presentation.setDefaultStyleRange(new StyleRange(region.getOffset(), region.getLength(), null, null));
                        TMPresentationReconciler.this.applyTextRegionCollection(presentation);
                    }
                }
            }
        }

        private IRegion widgetRegion2ModelRegion(TextEvent e) {
            int length;
            String text = e.getText();
            int n = length = text == null ? 0 : text.length();
            if (TMPresentationReconciler.this.viewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)TMPresentationReconciler.this.viewer;
                return extension.widgetRange2ModelRange((IRegion)new Region(e.getOffset(), length));
            }
            IRegion visible = TMPresentationReconciler.this.viewer.getVisibleRegion();
            Region region = new Region(e.getOffset() + visible.getOffset(), length);
            return region;
        }

        public void modelTokensChanged(ModelTokensChangedEvent e) {
            StyledText control = TMPresentationReconciler.this.viewer.getTextWidget();
            if (control != null) {
                control.getDisplay().asyncExec(() -> {
                    if (TMPresentationReconciler.this.viewer != null) {
                        TMPresentationReconciler.this.colorize(e);
                    }
                });
            }
        }
    }

    private class ThemeChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private ThemeChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            IThemeManager themeManager = TMUIPlugin.getThemeManager();
            if ("themeid".equals(event.getKey())) {
                this.preferenceThemeChange((String)event.getNewValue(), themeManager);
            } else if ("org.eclipse.tm4e.ui.themeAssociations".equals(event.getKey())) {
                this.preferenceThemeChange(PreferenceUtils.getE4PreferenceCSSThemeId(), themeManager);
            }
        }

        private void preferenceThemeChange(String eclipseThemeId, IThemeManager themeManager) {
            IDocument document = TMPresentationReconciler.this.viewer.getDocument();
            if (document == null) {
                return;
            }
            IGrammar grammar = TMPresentationReconciler.this.grammar;
            if (grammar == null) {
                return;
            }
            if (TMPresentationReconciler.this.forcedTheme) {
                return;
            }
            ITokenProvider oldTheme = TMPresentationReconciler.this.tokenProvider;
            boolean dark = themeManager.isDarkEclipseTheme(eclipseThemeId);
            ITheme newTheme = themeManager.getThemeForScope(grammar.getScopeName(), dark);
            TMPresentationReconciler.this.themeChange(oldTheme, newTheme, document);
        }
    }
}

