/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wildwebdeveloper.debug.NodeRunDebugLaunchShortcut;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.eclipse.wildwebdeveloper.tests.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestDebug {
    @Rule
    public AllCleanRule allClean = new AllCleanRule();
    private ILaunchManager launchManager;

    @Before
    public void setUpLaunch() throws DebugException {
        this.launchManager = DebugPlugin.getDefault().getLaunchManager();
        this.removeAllLaunches();
        DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.switch_perspective_on_suspend", "always");
    }

    private void removeAllLaunches() throws DebugException {
        ILaunch[] iLaunchArray = this.launchManager.getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            launch.terminate();
            ++n2;
        }
    }

    @After
    public void trearDownLaunch() throws DebugException {
        this.removeAllLaunches();
    }

    @Test
    public void testFindThreadsAndHitsBreakpoint() throws Exception {
        IProject project = Utils.provisionTestProject("helloWorldJS");
        IFile jsFile = project.getFile("hello.js");
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)jsFile);
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        TextSelection selection = new TextSelection(doc, 0, 0);
        IToggleBreakpointsTarget toggleBreakpointsTarget = DebugUITools.getToggleBreakpointsTargetManager().getToggleBreakpointsTarget((IWorkbenchPart)editor, (ISelection)selection);
        toggleBreakpointsTarget.toggleLineBreakpoints((IWorkbenchPart)editor, (ISelection)selection);
        final HashSet<IDebugTarget> before = new HashSet<IDebugTarget>(Arrays.asList(this.launchManager.getDebugTargets()));
        DisplayHelper.sleep((long)1000L);
        new NodeRunDebugLaunchShortcut().launch((IEditorPart)editor, "debug");
        Assert.assertTrue((String)"New Debug Target not created", (boolean)new DisplayHelper(){

            public boolean condition() {
                return TestDebug.this.launchManager.getDebugTargets().length > before.size();
            }
        }.waitForCondition(Display.getDefault(), 30000L));
        HashSet<IDebugTarget> after = new HashSet<IDebugTarget>(Arrays.asList(this.launchManager.getDebugTargets()));
        after.removeAll(before);
        Assert.assertEquals((String)"Extra DebugTarget not found", (long)1L, (long)after.size());
        final IDebugTarget target = (IDebugTarget)after.iterator().next();
        Assert.assertTrue((String)"Debug Target shows no threads", (boolean)new DisplayHelper(){

            public boolean condition() {
                try {
                    return target.getThreads().length > 0;
                }
                catch (DebugException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(Display.getDefault(), 3000L));
        target.getThreads();
        Assert.assertTrue((String)"No thread is suspended", (boolean)new DisplayHelper(){

            public boolean condition() {
                try {
                    return Arrays.stream(target.getThreads()).anyMatch(ISuspendResume::isSuspended);
                }
                catch (DebugException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(Display.getDefault(), 3000L));
    }
}

