/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.eclipse.wildwebdeveloper.tests.Utils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestAngular {
    @Rule
    public AllCleanRule cleanRule = new AllCleanRule();

    @Test
    public void testAngularTSFile() throws Exception {
        IProject project = Utils.provisionTestProject("angular-app");
        Process process = new ProcessBuilder(TestAngular.getNpmLocation(), "install", "--no-bin-links", "--ignore-scripts").directory(project.getLocation().toFile()).start();
        Assert.assertEquals((String)"npm install didn't complete property", (long)0L, (long)process.waitFor());
        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        final IFile appComponentFile = project.getFolder("src").getFolder("app").getFile("app.component.ts");
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)appComponentFile);
        DisplayHelper.sleep((long)4000L);
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        document.set(String.valueOf(document.get()) + "\n");
        Assert.assertTrue((String)"Diagnostic not published", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return appComponentFile.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 50000L));
        IMarker[] markers = appComponentFile.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0);
        boolean foundError = false;
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            int lineNumber = marker.getAttribute("lineNumber", -1);
            if (lineNumber == 6 && marker.getAttribute("message", "").contains("template")) {
                foundError = true;
            }
            ++n2;
        }
        Assert.assertTrue((String)"No error found in line 6", (boolean)foundError);
    }

    public static String getNpmLocation() {
        String res = "/path/to/npm";
        String[] command = new String[]{"/bin/bash", "-c", "-l", "which npm"};
        if (Platform.getOS().equals("win32")) {
            command = new String[]{"cmd", "/c", "where npm"};
        }
        BufferedReader reader = null;
        try {
            Process p = Runtime.getRuntime().exec(command);
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            res = reader.readLine();
        }
        catch (IOException e) {
            return Platform.getOS().equals("win32") ? "npm.cmd" : "npm";
        }
        if (res == null && Platform.getOS().equals("macosx")) {
            res = "/usr/local/bin/npm";
        } else if (res == null && Platform.getOS().equals("linux")) {
            res = "/usr/bin/npm";
        }
        if (res != null && Files.exists(Paths.get(res, new String[0]), new LinkOption[0])) {
            return res;
        }
        return Platform.getOS().equals("win32") ? "npm.cmd" : "npm";
    }
}

