/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLanguageServers {
    private IProject project;

    @Before
    public void setUpProject() throws Exception {
        ScopedPreferenceStore prefs = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.lsp4e");
        prefs.putValue("org.eclipse.wildwebdeveloper.jsts.file.logging.enabled", Boolean.toString(true));
        prefs.putValue("org.eclipse.wildwebdeveloper.css.file.logging.enabled", Boolean.toString(true));
        prefs.putValue("org.eclipse.wildwebdeveloper.html.file.logging.enabled", Boolean.toString(true));
        prefs.putValue("org.eclipse.wildwebdeveloper.json.file.logging.enabled", Boolean.toString(true));
        prefs.putValue("org.eclipse.wildwebdeveloper.xml.file.logging.enabled", Boolean.toString(true));
        prefs.putValue("org.eclipse.wildwebdeveloper.yaml.file.logging.enabled", Boolean.toString(true));
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(this.getClass().getName()) + System.nanoTime());
        this.project.create(null);
        this.project.open(null);
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference[] iViewReferenceArray = activePage.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            activePage.hideView(ref);
            ++n2;
        }
    }

    @After
    public void deleteProjectAndCloseEditors() throws Exception {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
        this.project.delete(true, null);
    }

    @Test
    public void testCSSFile() throws Exception {
        final IFile file = this.project.getFile("blah.css");
        file.create((InputStream)new ByteArrayInputStream("ERROR".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("FAIL");
        Assert.assertTrue((String)"Diagnostic not published", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L));
    }

    @Test
    public void testHTMLFile() throws Exception {
        final IFile file = this.project.getFile("blah.html");
        file.create((InputStream)new ByteArrayInputStream("FAIL".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("<style\n<html><");
        Assert.assertTrue((String)"Diagnostic not published", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L));
    }

    @Test
    public void testYAMLFile() throws Exception {
        final IFile file = this.project.getFile("blah.yaml");
        file.create((InputStream)new ByteArrayInputStream("FAIL".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("hello: '");
        Assert.assertTrue((String)"Diagnostic not published", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L));
    }

    @Test
    public void testXMLFile() throws Exception {
        final IFile file = this.project.getFile("blah.xml");
        file.create((InputStream)new ByteArrayInputStream("FAIL".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("<plugin></");
        Assert.assertTrue((String)"Diagnostic not published", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L));
    }

    @Test
    public void testXSLFile() throws Exception {
        final IFile file = this.project.getFile("blah.xsl");
        file.create((InputStream)new ByteArrayInputStream("FAIL".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("FAIL");
        Assert.assertTrue((String)"Diagnostic not published", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L));
    }

    @Test
    public void testXSDFile() throws Exception {
        final IFile file = this.project.getFile("blah.xsd");
        file.create((InputStream)new ByteArrayInputStream("FAIL".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("a<");
        Assert.assertTrue((String)"Diagnostic not published", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L));
    }

    @Test
    public void testDTDFile() throws Exception {
        final IFile file = this.project.getFile("blah.dtd");
        file.create((InputStream)new ByteArrayInputStream("FAIL".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("<!--<!-- -->");
        Assert.assertTrue((String)"Diagnostic not published", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L));
    }

    @Test
    public void testJSONFile() throws Exception {
        final IFile file = this.project.getFile("blah.json");
        file.create((InputStream)new ByteArrayInputStream("FAIL".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("ERROR");
        Assert.assertTrue((String)"Diagnostic not published", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L));
    }

    @Test
    public void testJSFile() throws Exception {
        final IFile file = this.project.getFile("blah.js");
        file.create((InputStream)new ByteArrayInputStream("ERROR".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        DisplayHelper.sleep((long)2000L);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("a<");
        Assert.assertTrue((String)"Diagnostic not published", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L));
    }

    @Test
    public void testTSFile() throws Exception {
        final IFile file = this.project.getFile("blah.ts");
        file.create((InputStream)new ByteArrayInputStream("ERROR".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("FAIL");
        Assert.assertTrue((String)"Diagnostic not published", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L));
    }

    @Test
    public void testJSXFile() throws Exception {
        final IFile file = this.project.getFile("blah.jsx");
        file.create((InputStream)new ByteArrayInputStream("ERROR".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("a<");
        Assert.assertTrue((String)"Diagnostic not published", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L));
    }

    @Test
    public void testTSXFile() throws Exception {
        final IFile file = this.project.getFile("blah.tsx");
        file.create((InputStream)new ByteArrayInputStream("ERROR".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("FAIL");
        Assert.assertTrue((String)"Diagnostic not published", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L));
    }
}

