/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.yaml;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.yaml.AddShemaGlobPatternDialog;

public class YAMLSchemaPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IPreferenceStore store;
    private Table schemaTable;

    public void init(IWorkbench workbench) {
        this.store = this.doGetPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        Label schemaLabel = new Label(parent, 0);
        schemaLabel.setLayoutData((Object)new GridData(768));
        schemaLabel.setText("Edit yaml.schemas");
        this.schemaTable = new Table(parent, 68354);
        this.schemaTable.setHeaderVisible(true);
        this.schemaTable.setLinesVisible(true);
        this.schemaTable.setLayoutData((Object)new GridData(1808));
        TableColumn schemaCol = new TableColumn(this.schemaTable, 0);
        schemaCol.setText("Schema");
        TableColumn globPatternCol = new TableColumn(this.schemaTable, 0);
        globPatternCol.setText("Glob Pattern");
        String schemaStr = this.store.getString("wildwebdeveloper.yaml.schema");
        Map schemas = (Map)new Gson().fromJson(schemaStr, new TypeToken<HashMap<String, String>>(){}.getType());
        for (String s : schemas.keySet()) {
            TableItem item = new TableItem(this.schemaTable, 0);
            item.setText(0, s);
            item.setText(1, (String)schemas.get(s));
        }
        Composite buttonsBar = new Composite(parent, 0);
        buttonsBar.setLayout((Layout)new RowLayout());
        buttonsBar.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        Button addButton = new Button(buttonsBar, 8);
        addButton.setText("Add");
        addButton.addListener(13, event -> {
            AddShemaGlobPatternDialog dialog = new AddShemaGlobPatternDialog(parent.getShell());
            dialog.create();
            if (dialog.open() == 0) {
                TableItem newItem = new TableItem(this.schemaTable, 0);
                newItem.setText(0, dialog.getSchemaKey());
                newItem.setText(1, dialog.getGlobPattern());
            }
        });
        Button removeButton = new Button(buttonsBar, 8);
        removeButton.setText("Remove");
        removeButton.addListener(13, event -> this.schemaTable.remove(this.schemaTable.getSelectionIndex()));
        schemaCol.pack();
        globPatternCol.pack();
        parent.layout();
        return new Composite(parent, 0);
    }

    public boolean performOk() {
        JsonObject schemaJson = new JsonObject();
        TableItem[] tableItemArray = this.schemaTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            schemaJson.addProperty(item.getText(0), item.getText(1));
            ++n2;
        }
        this.store.setValue("wildwebdeveloper.yaml.schema", schemaJson.toString());
        return true;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }
}

