import { DebugProtocol } from 'vscode-debugprotocol';
import { ICommonRequestArgs, ILaunchRequestArgs, ISetBreakpointsArgs, ISetBreakpointsResponseBody, IStackTraceResponseBody, IAttachRequestArgs, IScopesResponseBody, IVariablesResponseBody, ISourceResponseBody, IThreadsResponseBody, IEvaluateResponseBody, IDebugAdapter, ICompletionsResponseBody, IToggleSkipFileStatusArgs, ISetBreakpointResult, IRestartRequestArgs, IInitializeRequestArgs, ITelemetryPropertyCollector, IGetLoadedSourcesResponseBody, IExceptionInfoResponseBody, ISetVariableResponseBody } from '../debugAdapterInterfaces';
import { IChromeDebugAdapterOpts, ChromeDebugSession } from './chromeDebugSession';
import { ChromeConnection } from './chromeConnection';
import { Protocol as Crdp } from 'devtools-protocol';
import { ReasonType } from './stoppedEvent';
import { InternalSourceBreakpoint } from './internalSourceBreakpoint';
import { PromiseDefer } from '../utils';
import { StepProgressEventsEmitter } from '../executionTimingsReporter';
import { LineColTransformer } from '../transformers/lineNumberTransformer';
import { BasePathTransformer } from '../transformers/basePathTransformer';
import { BaseSourceMapTransformer } from '../transformers/baseSourceMapTransformer';
import { BreakOnLoadHelper } from './breakOnLoadHelper';
import { Breakpoints } from './breakpoints';
import { VariablesManager } from './variablesManager';
import { StackFrames } from './stackFrames';
import { ScriptContainer } from './scripts';
import { SmartStepper } from './smartStep';
import { ScriptSkipper } from './scriptSkipping';
export interface IPendingBreakpoint {
    args: ISetBreakpointsArgs;
    ids: number[];
    requestSeq: number;
    setWithPath: string;
}
export declare type VariableContext = 'variables' | 'watch' | 'repl' | 'hover';
export declare type CrdpScript = Crdp.Debugger.ScriptParsedEvent;
export declare type CrdpDomain = string;
export declare type LoadedSourceEventReason = 'new' | 'changed' | 'removed';
export interface BreakpointSetResult {
    isSet: boolean;
    breakpoint: DebugProtocol.Breakpoint;
}
export interface IOnPausedResult {
    didPause: boolean;
}
export interface Transformers {
    lineColTransformer: LineColTransformer;
    sourceMapTransformer: BaseSourceMapTransformer;
    pathTransformer: BasePathTransformer;
}
export declare abstract class ChromeDebugAdapter implements IDebugAdapter {
    static EVAL_NAME_PREFIX: string;
    static EVAL_ROOT: string;
    private static SCRIPTS_COMMAND;
    private static THREAD_ID;
    private static ASYNC_CALL_STACK_DEPTH;
    protected _session: ChromeDebugSession;
    protected _domains: Map<string, Crdp.Schema.Domain>;
    private _clientAttached;
    private _currentPauseNotification;
    private _exception;
    private _expectingResumedEvent;
    protected _expectingStopReason: ReasonType;
    private _waitAfterStep;
    protected _chromeConnection: ChromeConnection;
    protected _clientRequestedSessionEnd: boolean;
    protected _hasTerminated: boolean;
    protected _inShutdown: boolean;
    protected _attachMode: boolean;
    protected _launchAttachArgs: ICommonRequestArgs;
    protected _port: number;
    private _currentStep;
    private _currentLogMessage;
    private _pauseOnPromiseRejections;
    protected _promiseRejectExceptionFilterEnabled: boolean;
    private _columnBreakpointsEnabled;
    private _smartStepEnabled;
    private _smartStepCount;
    private _earlyScripts;
    private _initialSourceMapsP;
    private _lastPauseState;
    protected _breakOnLoadHelper: BreakOnLoadHelper | null;
    private _sourceLoadedQueue;
    private _scriptIdToBreakpointsAreResolvedDefer;
    private _batchTelemetryReporter;
    readonly events: StepProgressEventsEmitter;
    private _loadedSourcesByScriptId;
    protected _isVSClient: boolean;
    readonly columnBreakpointsEnabled: boolean;
    readonly breakOnLoadHelper: BreakOnLoadHelper;
    protected _scriptContainer: ScriptContainer;
    protected _breakpoints: Breakpoints;
    protected _variablesManager: VariablesManager;
    protected _stackFrames: StackFrames;
    protected _smartStepper: SmartStepper;
    protected _scriptSkipper: ScriptSkipper;
    private _transformers;
    constructor({chromeConnection, lineColTransformer, sourceMapTransformer, pathTransformer, targetFilter}: IChromeDebugAdapterOpts, session: ChromeDebugSession);
    readonly chrome: Crdp.ProtocolApi;
    /**
     * @deprecated
     */
    readonly scriptsById: Map<Crdp.Runtime.ScriptId, CrdpScript>;
    readonly committedBreakpointsByUrl: Map<string, ISetBreakpointResult[]>;
    readonly pathTransformer: BasePathTransformer;
    readonly sourceMapTransformer: BaseSourceMapTransformer;
    readonly lineColTransformer: LineColTransformer;
    readonly session: ChromeDebugSession;
    private readonly originProvider;
    /**
     * Called on 'clearEverything' or on a navigation/refresh
     */
    protected clearTargetContext(): void;
    initialize(args: IInitializeRequestArgs): DebugProtocol.Capabilities;
    configurationDone(): Promise<void>;
    readonly breakOnLoadActive: boolean;
    launch(args: ILaunchRequestArgs, telemetryPropertyCollector?: ITelemetryPropertyCollector): Promise<void>;
    attach(args: IAttachRequestArgs): Promise<void>;
    protected commonArgs(args: ICommonRequestArgs): void;
    shutdown(): void;
    protected terminateSession(reason: string, _disconnectArgs?: DebugProtocol.DisconnectArguments, restart?: IRestartRequestArgs): Promise<void>;
    /**
     * Hook up all connection events
     */
    protected hookConnectionEvents(): void;
    private runAndMeasureProcessingTime(notificationName, procedure);
    /**
     * Enable clients and run connection
     */
    protected runConnection(): Promise<void>[];
    protected doAttach(port: number, targetUrl?: string, address?: string, timeout?: number, websocketUrl?: string, extraCRDPChannelPort?: number): Promise<void>;
    private initSupportedDomains();
    /**
     * This event tells the client to begin sending setBP requests, etc. Some consumers need to override this
     * to send it at a later time of their choosing.
     */
    protected sendInitializedEvent(): Promise<void>;
    doAfterProcessingSourceEvents(action: () => void): Promise<void>;
    /**
     * e.g. the target navigated
     */
    protected onExecutionContextsCleared(): Promise<void>;
    protected onPaused(notification: Crdp.Debugger.PausedEvent, expectingStopReason?: ReasonType): Promise<IOnPausedResult>;
    exceptionInfo(args: DebugProtocol.ExceptionInfoArguments): Promise<IExceptionInfoResponseBody>;
    protected onResumed(): void;
    private detectColumnBreakpointSupport(scriptId);
    getBreakpointsResolvedDefer(scriptId: string): PromiseDefer<void>;
    protected onScriptParsed(script: Crdp.Debugger.ScriptParsedEvent): Promise<void>;
    protected sendLoadedSourceEvent(script: Crdp.Debugger.ScriptParsedEvent, loadedSourceEventReason?: LoadedSourceEventReason): Promise<void>;
    toggleSmartStep(): Promise<void>;
    toggleSkipFileStatus(args: IToggleSkipFileStatusArgs): Promise<void>;
    private isInCurrentStack(args);
    loadedSources(): Promise<IGetLoadedSourcesResponseBody>;
    protected onConsoleAPICalled(event: Crdp.Runtime.ConsoleAPICalledEvent): void;
    private onLogEntryAdded(event);
    private logObjects(objs, isError?, stackTrace?);
    protected onExceptionThrown(params: Crdp.Runtime.ExceptionThrownEvent): Promise<void>;
    /**
     * For backcompat, also listen to Console.messageAdded, only if it looks like the old format.
     */
    protected onMessageAdded(params: any): void;
    disconnect(args: DebugProtocol.DisconnectArguments): void;
    setBreakpoints(args: ISetBreakpointsArgs, _: ITelemetryPropertyCollector, requestSeq: number, ids?: number[]): Promise<ISetBreakpointsResponseBody>;
    private reportBpTelemetry(args);
    setExceptionBreakpoints(args: DebugProtocol.SetExceptionBreakpointsArguments): Promise<void>;
    /**
     * internal -> suppress telemetry
     */
    continue(internal?: boolean): Promise<void>;
    next(): Promise<void>;
    stepIn(userInitiated?: boolean): Promise<void>;
    stepOut(): Promise<void>;
    stepBack(): Promise<void>;
    reverseContinue(): Promise<void>;
    pause(): Promise<void>;
    stackTrace(args: DebugProtocol.StackTraceArguments): Promise<IStackTraceResponseBody>;
    /**
     * A stub method for overriding (used for the node debug adapter)
     */
    protected getReadonlyOrigin(_url: string): string;
    realPathToDisplayPath(realPath: string): string;
    displayPathToRealPath(displayPath: string): string;
    scopes(args: DebugProtocol.ScopesArguments): IScopesResponseBody;
    variables(args: DebugProtocol.VariablesArguments): Promise<IVariablesResponseBody>;
    source(args: DebugProtocol.SourceArguments): Promise<ISourceResponseBody>;
    threads(): IThreadsResponseBody;
    protected threadName(): string;
    evaluate(args: DebugProtocol.EvaluateArguments): Promise<IEvaluateResponseBody>;
    /**
     * Handle the .scripts command, which can be used as `.scripts` to return a list of all script details,
     * or `.scripts <url>` to show the contents of the given script.
     */
    private handleScriptsCommand(args);
    private _shouldSmartStepCallFrame(frame);
    /**
     * Allow consumers to override just because of https://github.com/nodejs/node/issues/8426
     */
    protected globalEvaluate(args: Crdp.Runtime.EvaluateRequest): Promise<Crdp.Runtime.EvaluateResponse>;
    private waitThenDoEvaluate(expression, frameId?, extraArgs?);
    private doEvaluate(expression, frameId?, extraArgs?);
    protected evaluateOnCallFrame(expression: string, frame: Crdp.Debugger.CallFrame, extraArgs?: Partial<Crdp.Runtime.EvaluateRequest>): Promise<Crdp.Debugger.EvaluateOnCallFrameResponse | Crdp.Runtime.EvaluateResponse>;
    setVariable(args: DebugProtocol.SetVariableArguments): Promise<ISetVariableResponseBody>;
    restartFrame(args: DebugProtocol.RestartFrameArguments): Promise<void>;
    completions(args: DebugProtocol.CompletionsArguments): Promise<ICompletionsResponseBody>;
    private getFlatAndUniqueCompletionItems(arrays);
    private getScriptByUrl(url);
    protected addBreakpoints(url: string, breakpoints: InternalSourceBreakpoint[]): Promise<ISetBreakpointResult[]>;
    protected validateBreakpointsPath(args: ISetBreakpointsArgs): Promise<void>;
    breakpointLocations(args: DebugProtocol.BreakpointLocationsArguments, _telemetryPropertyCollector?: ITelemetryPropertyCollector, requestSeq?: number): Promise<DebugProtocol.BreakpointLocationsResponse['body']>;
}
