/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.binding;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.internal.core.utils.binding.Binding;
import org.eclipse.wb.internal.core.utils.binding.BindingStatus;
import org.eclipse.wb.internal.core.utils.binding.IDataEditor;
import org.eclipse.wb.internal.core.utils.binding.IDataProvider;

public final class DataBindManager {
    private final List<Binding> m_bindings = new ArrayList<Binding>();
    private final List<Runnable> m_updateRunnables = new ArrayList<Runnable>();

    public void bind(IDataEditor editor, IDataProvider provider) {
        this.bind(editor, provider, false);
    }

    public void bind(IDataEditor editor, IDataProvider provider, boolean setValue) {
        this.m_bindings.add(new Binding(editor, provider));
        if (setValue) {
            editor.setValue(provider.getValue(false));
        }
    }

    public void addUpdateRunnable(Runnable runnable) {
        this.m_updateRunnables.add(runnable);
    }

    public void addUpdateEvent(Widget widget, int eventType) {
        widget.addListener(eventType, event -> this.runUpdateRunnables());
    }

    private void runUpdateRunnables() {
        for (Runnable runnable : this.m_updateRunnables) {
            runnable.run();
        }
    }

    public void performUpdate() {
        this.updateEditors(false);
    }

    public void performDefault() {
        this.updateEditors(true);
    }

    public void performCommit() {
        this.updateProviders();
    }

    private void updateProviders() {
        BindingStatus multiStatus = BindingStatus.ok();
        for (Binding binding : this.m_bindings) {
            IStatus status = binding.updateProvider();
            if (this.mergeStatus(multiStatus, status)) continue;
            return;
        }
    }

    private void updateEditors(boolean def) {
        for (Binding binding : this.m_bindings) {
            binding.updateEditor(def);
        }
        this.runUpdateRunnables();
    }

    private boolean mergeStatus(MultiStatus multiStatus, IStatus newStatus) {
        if (!newStatus.isOK()) {
            multiStatus.add(newStatus);
            return multiStatus.getSeverity() < 4;
        }
        return true;
    }
}

