/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.widgets;

import java.util.List;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.association.Association;
import org.eclipse.wb.internal.core.xml.model.association.Associations;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectClipboardCopy;
import org.eclipse.wb.internal.core.xml.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.xml.model.clipboard.XmlObjectMemento;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;
import org.eclipse.wb.internal.xwt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.xwt.model.widgets.TreeColumnInfo;
import org.eclipse.wb.internal.xwt.model.widgets.TreeItemInfo;

public class TreeInfo
extends CompositeInfo {
    private static int BORDER_WIDTH = 1;

    public TreeInfo(EditorContext context, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(context, description, creationSupport);
        this.contributeToClipboardCopy();
    }

    private void contributeToClipboardCopy() {
        this.addBroadcastListener(new XmlObjectClipboardCopy(){

            public void invoke(XmlObjectInfo object, List<ClipboardCommand> commands) throws Exception {
                if (object == TreeInfo.this) {
                    for (TreeColumnInfo column : TreeInfo.this.getColumns()) {
                        final XmlObjectMemento columnMemento = XmlObjectMemento.createMemento((XmlObjectInfo)column);
                        commands.add(new ClipboardCommand(){
                            private static final long serialVersionUID = 0L;

                            public void execute(XmlObjectInfo object) throws Exception {
                                XmlObjectInfo column = columnMemento.create(object);
                                XmlObjectUtils.add((XmlObjectInfo)column, (Association)Associations.direct(), (XmlObjectInfo)object, null);
                                columnMemento.apply();
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    protected void refresh_fetch() throws Exception {
        super.refresh_fetch();
        Object tree = this.getObject();
        int headerHeight = (Integer)ReflectionUtils.invokeMethod((Object)tree, (String)"getHeaderHeight()", (Object[])new Object[0]);
        int x = BORDER_WIDTH;
        int y = BORDER_WIDTH;
        for (TreeColumnInfo column : this.getColumns()) {
            int columnWidth = (Integer)ReflectionUtils.invokeMethod((Object)column.getObject(), (String)"getWidth()", (Object[])new Object[0]);
            Rectangle bounds = new Rectangle(x, y, columnWidth, headerHeight);
            column.setModelBounds(bounds);
            column.setBounds(bounds);
            x += columnWidth;
        }
    }

    public List<TreeColumnInfo> getColumns() {
        return this.getChildren(TreeColumnInfo.class);
    }

    public final List<TreeItemInfo> getItems() {
        return this.getChildren(TreeItemInfo.class);
    }
}

