/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.parser;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.xml.model.description.DescriptionPropertiesHelper;
import org.eclipse.wb.internal.core.xml.model.description.IDescriptionRulesProvider;
import org.eclipse.wb.internal.core.xml.model.description.internal.PropertyEditorDescription;
import org.eclipse.wb.internal.xwt.model.property.editor.style.StylePropertyEditor;
import org.xml.sax.Attributes;

public class XwtDescriptionRulesProvider
implements IDescriptionRulesProvider {
    public static final IDescriptionRulesProvider INSTANCE = new XwtDescriptionRulesProvider();

    private XwtDescriptionRulesProvider() {
    }

    public void addRules(Digester digester, EditorContext context, Class<?> componentClass) {
        if (Widget.class.isAssignableFrom(componentClass) || Viewer.class.isAssignableFrom(componentClass)) {
            this.addRule_forStylePropertyEditor(digester, context);
        }
    }

    private void addRule_forStylePropertyEditor(Digester digester, final EditorContext context) {
        String pattern = "component/constructors/constructor/parameter/editor";
        digester.addRule(pattern, new Rule(){

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                String editorId = attributes.getValue("id");
                PropertyEditor editor = DescriptionPropertiesHelper.getConfigurableEditor((String)editorId);
                this.digester.push((Object)new PropertyEditorDescription(context, editor));
            }

            public void end(String namespace, String name) throws Exception {
                PropertyEditorDescription description = (PropertyEditorDescription)this.digester.pop();
                PropertyEditor configuredEditor = description.getConfiguredEditor();
                if (configuredEditor instanceof StylePropertyEditor) {
                    ComponentDescription componentDescription = (ComponentDescription)this.digester.peek();
                    Class<StylePropertyEditor> key = StylePropertyEditor.class;
                    componentDescription.putArbitraryValue(key, (Object)configuredEditor);
                }
            }
        });
        ComponentDescriptionHelper.addConfigurableObjectParametersRules((Digester)digester, (String)pattern);
    }
}

