/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.databinding.model.IBindingInfo;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.ui.BindDialog;
import org.eclipse.wb.internal.core.databinding.ui.BindingElementsComposite;
import org.eclipse.wb.internal.core.databinding.ui.EditSelection;
import org.eclipse.wb.internal.core.databinding.ui.IBindingSelectionListener;
import org.eclipse.wb.internal.core.databinding.ui.ObserveElementsComposite;
import org.eclipse.wb.internal.core.databinding.ui.UiUtils;

public class EditComposite
extends Composite {
    private static final String MAIN_SASH_KEY = "Main_Sash";
    private static final String OBSERVES_SASH_KEY = "Observes_Sash";
    private final AbstractUIPlugin m_plugin;
    private final IDatabindingsProvider m_databindingsProvider;
    private final IDialogSettings m_settings;
    private final SashForm m_mainSashForm;
    private final SashForm m_observeSashForm;
    private final BindingElementsComposite m_bindingComposite;
    private final ObserveElementsComposite m_targetObserveComposite;
    private final ObserveElementsComposite m_modelObserveComposite;
    private final EditSelection m_selection = new EditSelection();
    private final SelectionListener m_createBindingListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            EditComposite.this.createBinding();
        }
    };

    public EditComposite(Composite parent, int style, AbstractUIPlugin plugin, IDatabindingsProvider databindingsProvider, IDialogSettings settings) {
        super(parent, style);
        this.m_plugin = plugin;
        this.m_databindingsProvider = databindingsProvider;
        this.m_settings = settings;
        this.setLayout((Layout)new FillLayout());
        this.m_mainSashForm = new SashForm((Composite)this, 512);
        this.m_bindingComposite = new BindingElementsComposite((Composite)this.m_mainSashForm, 0, this.m_databindingsProvider, this.m_settings);
        this.m_observeSashForm = new SashForm((Composite)this.m_mainSashForm, 256);
        this.m_targetObserveComposite = new ObserveElementsComposite((Composite)this.m_observeSashForm, 0, "Target", this.m_databindingsProvider, true);
        this.m_modelObserveComposite = new ObserveElementsComposite((Composite)this.m_observeSashForm, 0, "Model", this.m_databindingsProvider, true);
        new SelectionSynchronizer();
        this.m_bindingComposite.setEditBindingListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditComposite.this.editBinding();
            }
        });
        this.m_targetObserveComposite.getBindAction().addSelectionListener(this.m_createBindingListener);
        this.m_modelObserveComposite.getBindAction().addSelectionListener(this.m_createBindingListener);
        new ExpandedListener(this.m_targetObserveComposite){

            protected void handle() {
                EditComposite.this.m_selection.setTarget(EditComposite.this.m_databindingsProvider, EditComposite.this.m_targetObserveComposite);
            }
        };
        new ExpandedListener(this.m_modelObserveComposite){

            protected void handle() {
                EditComposite.this.m_selection.setModel(EditComposite.this.m_databindingsProvider, EditComposite.this.m_modelObserveComposite);
            }
        };
        UiUtils.loadSashWeights(this.m_mainSashForm, this.m_settings, MAIN_SASH_KEY, new int[]{1, 3});
        UiUtils.loadSashWeights(this.m_observeSashForm, this.m_settings, OBSERVES_SASH_KEY, new int[]{1, 1});
    }

    public void setInput(boolean refresh, EditSelection selection) {
        this.m_bindingComposite.setInput(refresh);
        if (refresh) {
            this.m_targetObserveComposite.refresh();
            this.m_modelObserveComposite.refresh();
        } else if (selection == null || !selection.setSelection(this.m_databindingsProvider, this.m_bindingComposite, this.m_targetObserveComposite, this.m_modelObserveComposite)) {
            this.m_targetObserveComposite.showPage(this.m_databindingsProvider.getTargetStartType());
            this.m_modelObserveComposite.showPage(this.m_databindingsProvider.getModelStartType());
        }
    }

    public EditSelection getEditSelection() {
        return this.m_selection;
    }

    public void performFinish() {
        UiUtils.saveSashWeights(this.m_mainSashForm, this.m_settings, MAIN_SASH_KEY);
        UiUtils.saveSashWeights(this.m_observeSashForm, this.m_settings, OBSERVES_SASH_KEY);
    }

    protected final void createBinding() {
        try {
            boolean isCtrlPressed = DesignerPlugin.isCtrlPressed();
            if (isCtrlPressed) {
                this.getShell().getDisplay().beep();
            }
            IObserveInfo target = this.m_targetObserveComposite.getMasterObserve();
            IObserveInfo targetProperty = this.m_targetObserveComposite.getPropertyObserve();
            IObserveInfo model = this.m_modelObserveComposite.getMasterObserve();
            IObserveInfo modelProperty = this.m_modelObserveComposite.getPropertyObserve();
            IBindingInfo binding = this.m_databindingsProvider.createBinding(target, targetProperty, model, modelProperty);
            BindDialog dialog = new BindDialog(this.getShell(), this.m_plugin, this.m_databindingsProvider, binding, true, isCtrlPressed);
            if (dialog.open() == 0) {
                this.m_databindingsProvider.addBinding(binding);
                if (!this.isDisposed()) {
                    this.m_targetObserveComposite.refresh();
                    this.m_modelObserveComposite.refresh();
                    this.m_bindingComposite.getViewer().refresh();
                    this.m_bindingComposite.getViewer().setSelection((ISelection)new StructuredSelection((Object)binding), true);
                    this.m_bindingComposite.setDeleteAllActionEnabled(true);
                }
            }
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
        }
    }

    protected final void editBinding() {
        IBindingInfo binding = this.m_bindingComposite.getSelectionBinding();
        BindDialog dialog = new BindDialog(this.getShell(), this.m_plugin, this.m_databindingsProvider, binding, false, false);
        if (dialog.open() == 0) {
            this.m_databindingsProvider.editBinding(binding);
            if (!this.isDisposed()) {
                this.m_targetObserveComposite.refresh();
                this.m_modelObserveComposite.refresh();
                this.m_bindingComposite.getViewer().refresh();
            }
        }
    }

    static IStructuredSelection getSelection(ObserveElementsComposite observeComposite, boolean forMaster) {
        TreeViewer viewer = forMaster ? observeComposite.getMasterViewer() : observeComposite.getPropertiesViewer();
        return (IStructuredSelection)viewer.getSelection();
    }

    private static abstract class ExpandedListener
    implements ITreeViewerListener {
        public ExpandedListener(ObserveElementsComposite observeElementsComposite) {
            observeElementsComposite.getMasterViewer().addTreeListener((ITreeViewerListener)this);
            observeElementsComposite.getPropertiesViewer().addTreeListener((ITreeViewerListener)this);
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            this.handle();
        }

        public void treeExpanded(TreeExpansionEvent event) {
            this.handle();
        }

        protected abstract void handle();
    }

    private class SelectionSynchronizer {
        private final IBindingSelectionListener m_bindingListener = new IBindingSelectionListener(){

            public void selectionChanged(IBindingInfo binding) {
                try {
                    SelectionSynchronizer.this.setObserveListener(false);
                    SelectionSynchronizer.this.handleBindingSelection(binding);
                }
                finally {
                    SelectionSynchronizer.this.setObserveListener(true);
                }
            }
        };
        private final ISelectionChangedListener m_observeListener = new ISelectionChangedListener(){
            boolean m_skipEvent;

            public void selectionChanged(SelectionChangedEvent event) {
                if (this.m_skipEvent) {
                    return;
                }
                this.m_skipEvent = true;
                try {
                    SelectionSynchronizer.this.setBindingListener(false);
                    SelectionSynchronizer.this.handleObserveSelection();
                }
                finally {
                    this.m_skipEvent = false;
                    SelectionSynchronizer.this.setBindingListener(true);
                }
            }
        };

        public SelectionSynchronizer() {
            this.setBindingListener(true);
            this.setObserveListener(true);
        }

        private void setBindingListener(boolean add) {
            EditComposite.this.m_bindingComposite.setBindingSelectionListener(add ? this.m_bindingListener : null);
        }

        private void setObserveListener(boolean add) {
            if (add) {
                EditComposite.this.m_targetObserveComposite.getMasterViewer().addPostSelectionChangedListener(this.m_observeListener);
                EditComposite.this.m_targetObserveComposite.getPropertiesViewer().addPostSelectionChangedListener(this.m_observeListener);
                EditComposite.this.m_modelObserveComposite.getMasterViewer().addPostSelectionChangedListener(this.m_observeListener);
                EditComposite.this.m_modelObserveComposite.getPropertiesViewer().addPostSelectionChangedListener(this.m_observeListener);
            } else {
                EditComposite.this.m_targetObserveComposite.getMasterViewer().removePostSelectionChangedListener(this.m_observeListener);
                EditComposite.this.m_targetObserveComposite.getPropertiesViewer().removePostSelectionChangedListener(this.m_observeListener);
                EditComposite.this.m_modelObserveComposite.getMasterViewer().removePostSelectionChangedListener(this.m_observeListener);
                EditComposite.this.m_modelObserveComposite.getPropertiesViewer().removePostSelectionChangedListener(this.m_observeListener);
            }
        }

        protected final void handleBindingSelection(IBindingInfo binding) {
            if (binding == null) {
                EditComposite.this.m_selection.clearBinding();
                EditComposite.this.m_targetObserveComposite.refresh();
                EditComposite.this.m_modelObserveComposite.refresh();
            } else {
                EditComposite.this.m_selection.setBinding(EditComposite.this.m_databindingsProvider, binding);
                EditComposite.this.m_targetObserveComposite.setSelection(binding.getTarget(), binding.getTargetProperty());
                EditComposite.this.m_modelObserveComposite.setSelection(binding.getModel(), binding.getModelProperty());
            }
        }

        protected final void handleObserveSelection() {
            EditComposite.this.m_selection.clearBinding();
            EditComposite.this.m_selection.setTarget(EditComposite.this.m_databindingsProvider, EditComposite.this.m_targetObserveComposite);
            EditComposite.this.m_selection.setModel(EditComposite.this.m_databindingsProvider, EditComposite.this.m_modelObserveComposite);
            IStructuredSelection targetSelection = EditComposite.getSelection(EditComposite.this.m_targetObserveComposite, true);
            IStructuredSelection targetPropertySelection = EditComposite.getSelection(EditComposite.this.m_targetObserveComposite, false);
            IStructuredSelection modelSelection = EditComposite.getSelection(EditComposite.this.m_modelObserveComposite, true);
            IStructuredSelection modelPropertySelection = EditComposite.getSelection(EditComposite.this.m_modelObserveComposite, false);
            if (UiUtils.isEmpty((ISelection)targetSelection) || UiUtils.isEmpty((ISelection)targetPropertySelection) || UiUtils.isEmpty((ISelection)modelSelection) || UiUtils.isEmpty((ISelection)modelPropertySelection)) {
                this.setActionsEnabled(false);
            } else {
                IObserveInfo target = (IObserveInfo)targetSelection.getFirstElement();
                IObserveInfo targetProperty = (IObserveInfo)targetPropertySelection.getFirstElement();
                IObserveInfo model = (IObserveInfo)modelSelection.getFirstElement();
                IObserveInfo modelProperty = (IObserveInfo)modelPropertySelection.getFirstElement();
                for (IBindingInfo binding : EditComposite.this.m_databindingsProvider.getBindings()) {
                    if (target != binding.getTarget() || targetProperty != binding.getTargetProperty() || model != binding.getModel() || modelProperty != binding.getModelProperty()) continue;
                    StructuredSelection selection = new StructuredSelection((Object)binding);
                    if (!selection.equals((Object)EditComposite.this.m_bindingComposite.getViewer().getSelection())) {
                        EditComposite.this.m_bindingComposite.getViewer().setSelection((ISelection)selection, true);
                    }
                    this.setActionsEnabled(false);
                    EditComposite.this.m_selection.setBinding(EditComposite.this.m_databindingsProvider, binding);
                    return;
                }
                try {
                    this.setActionsEnabled(EditComposite.this.m_databindingsProvider.validate(target, targetProperty, model, modelProperty));
                }
                catch (Throwable e) {
                    DesignerPlugin.log((Throwable)e);
                }
            }
        }

        private void setActionsEnabled(boolean enabled) {
            EditComposite.this.m_targetObserveComposite.getBindAction().setEnabled(enabled);
            EditComposite.this.m_modelObserveComposite.getBindAction().setEnabled(enabled);
        }
    }
}

