/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor.actions;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.xml.editor.actions.IPairResourceProvider;

public class SwitchPairEditorAction
extends Action
implements IEditorActionDelegate {
    private IEditorPart m_editor;
    private IFile m_pairFile;

    public final void setActiveEditor(IAction action, IEditorPart editor) {
        this.m_editor = editor;
        this.m_pairFile = null;
    }

    private void preparePairFile() {
        if (this.m_pairFile != null) {
            return;
        }
        if (this.m_editor == null) {
            return;
        }
        if (!(this.m_editor.getEditorInput() instanceof IFileEditorInput)) {
            return;
        }
        IFile editorFile = ((IFileEditorInput)this.m_editor.getEditorInput()).getFile();
        List providers = ExternalFactoriesHelper.getElementsInstances(IPairResourceProvider.class, (String)"org.eclipse.wb.core.xml.pairResourceProviders", (String)"provider");
        for (IPairResourceProvider provider : providers) {
            IFile pairFile = provider.getPair(editorFile);
            if (pairFile == null || !pairFile.exists()) continue;
            this.m_pairFile = pairFile;
            break;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                SwitchPairEditorAction.this.preparePairFile();
                if (SwitchPairEditorAction.this.m_pairFile != null) {
                    IDE.openEditor((IWorkbenchPage)DesignerPlugin.getActivePage(), (IFile)SwitchPairEditorAction.this.m_pairFile);
                }
            }
        });
    }
}

