/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.branding;

import org.eclipse.wb.core.branding.IBrandingDescription;
import org.eclipse.wb.core.branding.IBrandingSupportInfo;
import org.eclipse.wb.draw2d.Graphics;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.utils.platform.PluginUtilities;

public abstract class AbstractBrandingDescription
implements IBrandingDescription {
    private final String m_productName;
    private final IBrandingSupportInfo m_supportInfo;

    protected AbstractBrandingDescription(String productName, IBrandingSupportInfo supportInfo) {
        this.m_productName = productName;
        this.m_supportInfo = supportInfo;
    }

    public String getProductName() {
        return this.m_productName;
    }

    public IBrandingSupportInfo getSupportInfo() {
        return this.m_supportInfo;
    }

    public void paintBrandingOnCanvas(Rectangle clientArea, Graphics graphics) {
        String version = PluginUtilities.getVersionString("org.eclipse.wb.core");
        this.paintBrandingOnCanvas_grayText(clientArea, graphics, version);
    }

    protected final void paintBrandingOnCanvas_grayText(Rectangle clientArea, Graphics graphics, String text) {
        Dimension extent = graphics.getTextExtent(text);
        graphics.setForegroundColor(IColorConstants.lightGray);
        int x = clientArea.right() - extent.width - 2;
        int y = clientArea.bottom() - extent.height - 0;
        graphics.drawText(text, x, y);
    }
}

