/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.model.association;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompoundAssociation
extends Association {
    private final List<Association> m_associations = Lists.newArrayList();
    private final List<Association> m_newAssociations = Lists.newArrayList();

    public CompoundAssociation(Association ... associations) {
        Association[] associationArray = associations;
        int n = associations.length;
        int n2 = 0;
        while (n2 < n) {
            Association association = associationArray[n2];
            Assert.isNotNull(association);
            if (association instanceof CompoundAssociation) {
                CompoundAssociation compoundAssociation = (CompoundAssociation)association;
                this.m_associations.addAll(compoundAssociation.m_associations);
            } else {
                this.m_associations.add(association);
            }
            ++n2;
        }
    }

    public List<Association> getAssociations() {
        return this.m_associations;
    }

    public void add(Association association) {
        Assert.isNotNull(association);
        this.m_newAssociations.add(association);
    }

    @Override
    public void setJavaInfo(JavaInfo javaInfo) throws Exception {
        super.setJavaInfo(javaInfo);
        for (Association association : this.m_associations) {
            if (association.getJavaInfo() != null) {
                Assert.isTrue(association.getJavaInfo() == javaInfo);
                continue;
            }
            association.setJavaInfo(javaInfo);
        }
    }

    @Override
    public boolean canDelete() {
        for (Association association : this.m_associations) {
            if (association.canDelete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Statement getStatement() {
        Assert.isTrue(!this.m_associations.isEmpty());
        return this.m_associations.get(0).getStatement();
    }

    @Override
    public String getSource() {
        Assert.isTrue(!this.m_associations.isEmpty());
        return this.m_associations.get(0).getSource();
    }

    @Override
    public void add(JavaInfo javaInfo, StatementTarget target, String[] leadingComments) throws Exception {
        for (Association association : this.m_associations) {
            association.add(javaInfo, target, leadingComments);
            leadingComments = null;
        }
        this.setInModelNoCompound(javaInfo);
    }

    @Override
    public boolean remove() throws Exception {
        Iterator<Association> I = this.m_associations.iterator();
        while (I.hasNext()) {
            Association association = I.next();
            if (!association.remove()) continue;
            I.remove();
        }
        if (this.m_associations.isEmpty()) {
            this.removeFromModelIfPrimary();
            return true;
        }
        return false;
    }

    @Override
    public void setParent(JavaInfo parent) throws Exception {
        for (Association association : this.m_associations) {
            association.setParent(parent);
        }
        StatementTarget target = new StatementTarget(this.getStatement(), false);
        for (Association association : this.m_newAssociations) {
            association.add(this.m_javaInfo, target, null);
            this.m_associations.add(association);
        }
        this.m_newAssociations.clear();
    }

    @Override
    public Association getCopy() {
        Association[] newAssociations = new Association[this.m_associations.size()];
        int i = 0;
        while (i < this.m_associations.size()) {
            newAssociations[i] = this.m_associations.get(i).getCopy();
            ++i;
        }
        return new CompoundAssociation(newAssociations);
    }
}

