/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.helpers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.model.description.IToolkitProvider;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ILoadingContext;
import org.eclipse.wb.internal.core.model.description.resource.ClassResourceInfo;
import org.eclipse.wb.internal.core.model.description.resource.IDescriptionVersionsProvider;
import org.eclipse.wb.internal.core.model.description.resource.ResourceInfo;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DescriptionHelper {
    private static Schema m_wbpComponentSchema;
    public static final String[] ICON_EXTS;
    private static final String POINT_TOOLKITS = "org.eclipse.wb.core.toolkits";
    private static Map<String, ToolkitDescription> m_idToToolkit;

    static {
        ICON_EXTS = new String[]{".png", ".gif"};
    }

    public static void addDescriptionResources(LinkedList<ClassResourceInfo> descriptions, ILoadingContext context, Class<?> currentClass) throws Exception {
        if (currentClass != null) {
            ResourceInfo resource = DescriptionHelper.getComponentDescriptionResource(context, currentClass);
            if (resource != null) {
                DescriptionHelper.validateComponentDescription(resource);
                descriptions.addFirst(new ClassResourceInfo(currentClass, resource));
            }
            Class<?>[] classArray = currentClass.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interfaceClass = classArray[n2];
                DescriptionHelper.addDescriptionResources(descriptions, context, interfaceClass);
                ++n2;
            }
            DescriptionHelper.addDescriptionResources(descriptions, context, currentClass.getSuperclass());
        }
    }

    public static synchronized void validateComponentDescription(ResourceInfo resource) throws Exception {
        if (EnvironmentUtils.isTestingTime()) {
            if (m_wbpComponentSchema == null) {
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                InputStream schemaStream = DesignerPlugin.getFile("schema/wbp-component.xsd");
                m_wbpComponentSchema = factory.newSchema(new StreamSource(schemaStream));
            }
            InputStream contents = resource.getURL().openStream();
            try {
                try {
                    Validator validator = m_wbpComponentSchema.newValidator();
                    validator.validate(new StreamSource(contents));
                }
                catch (Throwable e) {
                    throw new Exception("Exception during validation " + resource.getURL(), e);
                }
            }
            finally {
                contents.close();
            }
        }
    }

    public static Image getIconImage(ILoadingContext context, Class<?> componentClass) throws Exception {
        return DescriptionHelper.getIconImage(context, componentClass, "");
    }

    public static Image getIconImage(ILoadingContext context, Class<?> componentClass, String suffix) throws Exception {
        String iconPath = String.valueOf(componentClass.getName().replace('.', '/')) + suffix;
        return DescriptionHelper.getIconImage(context, iconPath);
    }

    public static Image getIconImage(ILoadingContext context, String iconPath) throws Exception {
        String[] stringArray = ICON_EXTS;
        int n = ICON_EXTS.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            String iconName = String.valueOf(iconPath) + ext;
            ResourceInfo resourceInfo = DescriptionHelper.getResourceInfo0(context, iconName, true);
            if (resourceInfo != null) {
                InputStream stream = resourceInfo.getURL().openStream();
                try {
                    Image image = new Image(null, stream);
                    return image;
                }
                finally {
                    stream.close();
                }
            }
            ++n2;
        }
        return null;
    }

    public static boolean hasForcedToolkitForComponent(ILoadingContext context, String toolkitId, String componentClassName) throws Exception {
        String name = String.valueOf(componentClassName.replace('.', '/')) + ".wbp-forced-toolkit.txt";
        ResourceInfo resourceInfo = DescriptionHelper.getResourceInfo0(context, name, true);
        if (resourceInfo != null) {
            return IOUtils2.readString(resourceInfo.getURL().openStream()).equals(toolkitId);
        }
        return false;
    }

    public static boolean hasComponentDescriptionResource(ILoadingContext context, Class<?> componentClass) throws Exception {
        return DescriptionHelper.getComponentDescriptionResource(context, componentClass) != null;
    }

    public static ResourceInfo getComponentDescriptionResource(ILoadingContext context, Class<?> componentClass) throws Exception {
        String name = String.valueOf(componentClass.getName().replace('.', '/')) + ".wbp-component.xml";
        return DescriptionHelper.getResourceInfo(context, componentClass, name);
    }

    static ResourceInfo getResourceInfo(ILoadingContext context, Class<?> resourceClass, String defaultPath) throws Exception {
        for (IDescriptionVersionsProvider provider : context.getDescriptionVersionsProviders()) {
            List<String> versions = provider.getVersions(resourceClass);
            for (String version : versions) {
                String versionedPath = String.valueOf(version) + "/" + defaultPath;
                ResourceInfo resource = DescriptionHelper.getResourceInfo0(context, versionedPath, false);
                if (resource == null) continue;
                return resource;
            }
        }
        return DescriptionHelper.getResourceInfo0(context, defaultPath, true);
    }

    private static ResourceInfo getResourceInfo0(ILoadingContext context, String name, boolean tryContext) throws Exception {
        ResourceInfo result;
        String key = "ComponentDescriptionHelper.getResourceInfo0.hasResult";
        Map cacheResult = (Map)context.getGlobalValue(key);
        if (cacheResult == null) {
            cacheResult = Maps.newHashMap();
            context.putGlobalValue(key, cacheResult);
        }
        if ((result = (ResourceInfo)cacheResult.get(name)) != null) {
            return result;
        }
        String key2 = "ComponentDescriptionHelper.getResourceInfo0.noResult";
        Set cacheNoResult = (Set)context.getGlobalValue(key2);
        if (cacheNoResult == null) {
            cacheNoResult = Sets.newHashSet();
            context.putGlobalValue(key2, cacheNoResult);
        }
        if (cacheNoResult.contains(name)) {
            return null;
        }
        result = DescriptionHelper.getResourceInfo00(context, name, tryContext);
        if (result != null) {
            cacheResult.put(name, result);
        } else {
            cacheNoResult.add(name);
        }
        return result;
    }

    private static ResourceInfo getResourceInfo00(ILoadingContext context, String name, boolean tryContext) throws Exception {
        Object resource = DescriptionHelper.getResourceInfo(name, context.getToolkitId());
        if (resource != null) {
            return resource;
        }
        for (IConfigurationElement toolkitElement : DescriptionHelper.getToolkitElements()) {
            if (!DescriptionHelper.hasMatchingResourcePrefix(toolkitElement, name)) continue;
            return null;
        }
        if (tryContext && (resource = context.getResource(name)) != null) {
            return new ResourceInfo(null, null, (URL)resource);
        }
        return null;
    }

    private static ResourceInfo getResourceInfo(IConfigurationElement toolkitElement, String name) throws Exception {
        if (!DescriptionHelper.canHaveResource(toolkitElement, name)) {
            return null;
        }
        String toolkitId = ExternalFactoriesHelper.getRequiredAttribute(toolkitElement, "id");
        Bundle bundle = ExternalFactoriesHelper.getExtensionBundle(toolkitElement);
        return DescriptionHelper.getResourceInfo(toolkitId, bundle, name);
    }

    private static boolean canHaveResource(IConfigurationElement toolkitElement, String name) {
        IConfigurationElement[] prefixElements = DescriptionHelper.getResourcePrefixElements(toolkitElement);
        if (prefixElements.length != 0) {
            return DescriptionHelper.hasMatchingResourcePrefix(prefixElements, name);
        }
        return true;
    }

    private static boolean hasMatchingResourcePrefix(IConfigurationElement toolkitElement, String name) {
        IConfigurationElement[] prefixElements = DescriptionHelper.getResourcePrefixElements(toolkitElement);
        return DescriptionHelper.hasMatchingResourcePrefix(prefixElements, name);
    }

    private static IConfigurationElement[] getResourcePrefixElements(IConfigurationElement toolkitElement) {
        IConfigurationElement[] prefixContainers;
        IConfigurationElement[] iConfigurationElementArray = prefixContainers = toolkitElement.getChildren("resourcePrefixes");
        if (prefixContainers.length != 0) {
            IConfigurationElement containerElement = iConfigurationElementArray[0];
            return containerElement.getChildren("resourcePrefix");
        }
        return new IConfigurationElement[0];
    }

    private static boolean hasMatchingResourcePrefix(IConfigurationElement[] prefixElements, String name) {
        IConfigurationElement[] iConfigurationElementArray = prefixElements;
        int n = prefixElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement prefixElement = iConfigurationElementArray[n2];
            String prefix = prefixElement.getValue().replace('.', '/');
            if (name.startsWith(prefix)) {
                return true;
            }
            String nameWithoutVersion = StringUtils.substringAfter((String)name, (String)"/");
            if (nameWithoutVersion.startsWith(prefix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ResourceInfo getResourceInfo(String toolkitId, Bundle bundle, String name) throws Exception {
        URL resource = bundle.getEntry("wbp-meta/" + name);
        if (resource != null) {
            ToolkitDescription toolkit = toolkitId != null ? DescriptionHelper.getToolkit(toolkitId) : null;
            return new ResourceInfo(bundle, toolkit, resource);
        }
        return null;
    }

    public static ResourceInfo getResourceInfo(String name) throws Exception {
        return DescriptionHelper.getResourceInfo(name, null);
    }

    public static ResourceInfo getResourceInfo(String name, String activeToolkitId) throws Exception {
        List<IConfigurationElement> toolkitElements = DescriptionHelper.getToolkitElements();
        if (!StringUtils.isEmpty((String)activeToolkitId)) {
            for (IConfigurationElement toolkitElement : toolkitElements) {
                ResourceInfo resourceInfo;
                String toolkitId = ExternalFactoriesHelper.getRequiredAttribute(toolkitElement, "id");
                if (!toolkitId.equals(activeToolkitId) || (resourceInfo = DescriptionHelper.getResourceInfo(toolkitElement, name)) == null) continue;
                return resourceInfo;
            }
        }
        for (IConfigurationElement toolkitElement : toolkitElements) {
            ResourceInfo resourceInfo = DescriptionHelper.getResourceInfo(toolkitElement, name);
            if (resourceInfo == null) continue;
            return resourceInfo;
        }
        return null;
    }

    public static List<IConfigurationElement> getToolkitElements() {
        return ExternalFactoriesHelper.getElements(POINT_TOOLKITS, "toolkit");
    }

    public static List<IConfigurationElement> getToolkitElements(String toolkitId) {
        List toolkitElements = Lists.newArrayList();
        for (IConfigurationElement element : DescriptionHelper.getToolkitElements()) {
            if (!ExternalFactoriesHelper.getRequiredAttribute(element, "id").equals(toolkitId)) continue;
            toolkitElements.add(element);
        }
        return toolkitElements;
    }

    public static ToolkitDescription[] getToolkits() throws Exception {
        List toolkits = Lists.newArrayList();
        Set addedToolkits = Sets.newHashSet();
        for (IConfigurationElement toolkitElement : DescriptionHelper.getToolkitElements()) {
            String id = toolkitElement.getAttribute("id");
            if (addedToolkits.contains(id)) continue;
            addedToolkits.add(id);
            toolkits.add(DescriptionHelper.getToolkit(id));
        }
        return toolkits.toArray(new ToolkitDescription[toolkits.size()]);
    }

    public static synchronized ToolkitDescription getToolkit(String toolkitId) throws Exception {
        Assert.isNotNull(toolkitId);
        if (m_idToToolkit == null) {
            m_idToToolkit = Maps.newTreeMap();
            for (IConfigurationElement toolkitElement : DescriptionHelper.getToolkitElements()) {
                IConfigurationElement[] providerElements;
                IConfigurationElement[] iConfigurationElementArray = providerElements = toolkitElement.getChildren("provider");
                int n = providerElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement providerElement = iConfigurationElementArray[n2];
                    IToolkitProvider toolkitProvider = (IToolkitProvider)providerElement.createExecutableExtension("class");
                    ToolkitDescription toolkitDescription = toolkitProvider.getDescription();
                    m_idToToolkit.put(toolkitDescription.getId(), toolkitDescription);
                    ++n2;
                }
            }
        }
        ToolkitDescription toolkitDescription = m_idToToolkit.get(toolkitId);
        Assert.isNotNull(toolkitDescription, "Can not find description for toolkit: " + toolkitId);
        return toolkitDescription;
    }

    public static Class<?> loadModelClass(String className) throws Exception {
        for (IConfigurationElement toolkitElement : DescriptionHelper.getToolkitElements()) {
            Bundle bundle = ExternalFactoriesHelper.getExtensionBundle(toolkitElement);
            try {
                return bundle.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        throw new ClassNotFoundException(className);
    }
}

