/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.configurable;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.description.ConfigurablePropertyDescription;
import org.eclipse.wb.internal.core.model.property.IConfigurablePropertyFactory;
import org.eclipse.wb.internal.core.model.property.IConfigurablePropertyObject;
import org.eclipse.wb.internal.core.model.property.JavaProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.configurable.StringsAddPropertyEditor;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public final class StringsAddPropertyFactory
implements IConfigurablePropertyFactory {
    public Property create(JavaInfo javaInfo, ConfigurablePropertyDescription description) throws Exception {
        ConfigurableProperty property = new ConfigurableProperty(javaInfo, description.getTitle());
        if (property.getEditor() instanceof IConfigurablePropertyObject) {
            EditorState editorState = EditorState.get(javaInfo.getEditor());
            IConfigurablePropertyObject editor = (IConfigurablePropertyObject)((Object)property.getEditor());
            description.configure(editorState, editor);
        }
        return property;
    }

    private static final class ConfigurableProperty
    extends JavaProperty {
        private final StringsAddPropertyEditor m_stringsEditor = (StringsAddPropertyEditor)this.getEditor();

        public ConfigurableProperty(JavaInfo javaInfo, String title) {
            super(javaInfo, title, new StringsAddPropertyEditor());
        }

        public boolean isModified() throws Exception {
            return this.m_stringsEditor.getItems(this).length != 0;
        }

        public Object getValue() throws Exception {
            return this.m_stringsEditor.getItems(this);
        }

        public void setValue(Object value) throws Exception {
            if (value instanceof String[]) {
                this.m_stringsEditor.setItems(this, (String[])value);
            }
        }
    }
}

