/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.model.ui;

import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableTitleAreaDialog;
import org.eclipse.wb.internal.swing.FormLayout.Activator;
import org.eclipse.wb.internal.swing.FormLayout.model.FormDimensionInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormDimensionTemplate;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.ModelMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DimensionsDialog<T extends FormDimensionInfo>
extends ResizableTitleAreaDialog {
    protected final FormLayoutInfo m_layout;
    private final List<T> m_dimensions;
    private final int m_minimumDimensions;
    private TableViewer m_viewer;
    private Button m_editButton;
    private Button m_removeButton;
    private Button m_moveUpButton;
    private Button m_moveDownButton;

    public DimensionsDialog(Shell parentShell, FormLayoutInfo layout, List<T> dimensions, int minimumDimensions) {
        super(parentShell, (AbstractUIPlugin)Activator.getDefault());
        this.setShellStyle(80);
        this.m_layout = layout;
        this.m_dimensions = dimensions;
        this.m_minimumDimensions = minimumDimensions;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridDataFactory.create((Control)container).grab().fill();
        GridLayoutFactory.create((Composite)container).columns(2);
        Label label = new Label(container, 0);
        GridDataFactory.create((Control)label).spanH(2);
        label.setText(this.getViewerTitle());
        this.createViewer(container);
        this.createButtonsComposite(container);
        this.updateButtons();
        this.setTitle(this.getDialogTitle());
        this.setMessage(this.getDialogMessage());
        return area;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getDialogTitle());
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            try {
                try {
                    this.m_layout.startEdit();
                    this.updateLayoutInfo(this.m_dimensions);
                }
                finally {
                    this.m_layout.endEdit();
                }
            }
            catch (Throwable e) {
                DesignerPlugin.log((Throwable)e);
            }
        }
        super.buttonPressed(buttonId);
    }

    protected abstract void updateLayoutInfo(List<T> var1) throws Exception;

    private void createViewer(Composite container) {
        this.m_viewer = new TableViewer(container, 67586);
        Table table = this.m_viewer.getTable();
        GridDataFactory.create((Control)table).hintC(120, 15).grab().fill();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createColumn(ModelMessages.DimensionsDialog_numberColumn, 5);
        this.createColumn(ModelMessages.DimensionsDialog_templateColumn, 35);
        this.createColumn(ModelMessages.DimensionsDialog_alignmentColumn, 15);
        this.createColumn(ModelMessages.DimensionsDialog_sizeColumn, 35);
        this.createColumn(ModelMessages.DimensionsDialog_resizingColumn, 15);
        this.m_viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new DimensionsLabelProvider());
        this.m_viewer.setInput(this.m_dimensions);
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DimensionsDialog.this.updateButtons();
            }
        });
        this.m_viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DimensionsDialog.this.editSelectedDimension();
            }
        });
    }

    private void createColumn(String text, int widthInChars) {
        TableColumn column = new TableColumn(this.m_viewer.getTable(), 0);
        column.setText(text);
        column.setWidth(this.convertWidthInCharsToPixels(widthInChars));
    }

    private void createButtonsComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.create((Control)composite).fill();
        GridLayoutFactory.create((Composite)composite).marginsV(0);
        DimensionsDialog.createButton(composite, ModelMessages.DimensionsDialog_insertButton, new Listener(){

            public void handleEvent(Event event) {
                DimensionsDialog.this.addNewDimension(0);
            }
        });
        DimensionsDialog.createButton(composite, ModelMessages.DimensionsDialog_appendButton, new Listener(){

            public void handleEvent(Event event) {
                DimensionsDialog.this.addNewDimension(1);
            }
        });
        this.m_editButton = DimensionsDialog.createButton(composite, ModelMessages.DimensionsDialog_editButton, new Listener(){

            public void handleEvent(Event event) {
                DimensionsDialog.this.editSelectedDimension();
            }
        });
        this.m_removeButton = DimensionsDialog.createButton(composite, ModelMessages.DimensionsDialog_removeButton, new Listener(){

            public void handleEvent(Event event) {
                int index = 0;
                for (FormDimensionInfo dimension : GenericsUtils.iterable((ISelection)DimensionsDialog.this.m_viewer.getSelection())) {
                    index = DimensionsDialog.this.m_dimensions.indexOf(dimension);
                    DimensionsDialog.this.m_dimensions.remove(dimension);
                }
                DimensionsDialog.this.m_viewer.refresh();
                index = Math.min(index, DimensionsDialog.this.m_dimensions.size() - 1);
                DimensionsDialog.this.m_viewer.getTable().select(index);
                DimensionsDialog.this.updateButtons();
                DimensionsDialog.this.validateMinimumDimensions();
            }
        });
        new Label(composite, 0);
        this.m_moveUpButton = DimensionsDialog.createButton(composite, ModelMessages.DimensionsDialog_moveUpButton, new Listener(){

            public void handleEvent(Event event) {
                for (FormDimensionInfo dimension : GenericsUtils.iterable((ISelection)DimensionsDialog.this.m_viewer.getSelection())) {
                    int index = DimensionsDialog.this.m_dimensions.indexOf(dimension);
                    DimensionsDialog.this.m_dimensions.remove(dimension);
                    DimensionsDialog.this.m_dimensions.add(index - 1, dimension);
                }
                DimensionsDialog.this.m_viewer.refresh();
                DimensionsDialog.this.updateButtons();
            }
        });
        this.m_moveDownButton = DimensionsDialog.createButton(composite, ModelMessages.DimensionsDialog_moveDownButton, new Listener(){

            public void handleEvent(Event event) {
                for (FormDimensionInfo dimension : GenericsUtils.iterable((ISelection)DimensionsDialog.this.m_viewer.getSelection())) {
                    int index = DimensionsDialog.this.m_dimensions.indexOf(dimension);
                    DimensionsDialog.this.m_dimensions.remove(dimension);
                    DimensionsDialog.this.m_dimensions.add(index + 1, dimension);
                }
                DimensionsDialog.this.m_viewer.refresh();
                DimensionsDialog.this.updateButtons();
            }
        });
    }

    private static Button createButton(Composite parent, String text, Listener listener) {
        Button button = new Button(parent, 0);
        GridDataFactory.create((Control)button).grabH().fillH();
        button.setText(text);
        button.addListener(13, listener);
        return button;
    }

    private void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.m_viewer.getSelection();
        boolean empty = selection.isEmpty();
        this.m_editButton.setEnabled(selection.size() == 1);
        this.m_removeButton.setEnabled(!empty);
        this.m_moveUpButton.setEnabled(!empty);
        this.m_moveDownButton.setEnabled(!empty);
        for (FormDimensionInfo dimension : GenericsUtils.iterable((ISelection)selection)) {
            int index = this.m_dimensions.indexOf(dimension);
            if (index == 0) {
                this.m_moveUpButton.setEnabled(false);
            }
            if (index != this.m_dimensions.size() - 1) continue;
            this.m_moveDownButton.setEnabled(false);
        }
    }

    private void validateMinimumDimensions() {
        if (this.m_dimensions.size() < this.m_minimumDimensions) {
            this.setErrorMessage(this.getMinimalErrorMessage(this.m_minimumDimensions));
        } else {
            this.setErrorMessage(null);
        }
    }

    private void addNewDimension(int indexOffset) {
        try {
            T newDimension = this.createNewDimension();
            int index = this.m_viewer.getTable().getSelectionIndex();
            if (index == -1) {
                this.m_dimensions.add(newDimension);
            } else {
                this.m_dimensions.add(index + indexOffset, newDimension);
            }
            if (!this.editSelectedDimension(this.m_dimensions, newDimension)) {
                this.m_dimensions.remove(newDimension);
            }
            this.m_viewer.refresh();
            this.validateMinimumDimensions();
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
        }
    }

    private void editSelectedDimension() {
        FormDimensionInfo dimension = (FormDimensionInfo)GenericsUtils.first((ISelection)this.m_viewer.getSelection());
        this.editSelectedDimension(this.m_dimensions, dimension);
        this.m_viewer.refresh();
    }

    protected abstract String getDialogTitle();

    protected abstract String getDialogMessage();

    protected abstract String getMinimalErrorMessage(int var1);

    protected abstract String getViewerTitle();

    protected abstract boolean editSelectedDimension(List<T> var1, T var2);

    protected abstract T createNewDimension() throws Exception;

    private class DimensionsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private DimensionsLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            FormDimensionInfo dimension = (FormDimensionInfo)element;
            if (columnIndex == 0) {
                int index = DimensionsDialog.this.m_dimensions.indexOf(element);
                return "" + (index + 1);
            }
            if (columnIndex == 1) {
                FormDimensionTemplate template = dimension.getTemplate();
                if (template != null) {
                    return template.getTitle();
                }
                return "";
            }
            if (columnIndex == 2) {
                return dimension.getAlignment().toString();
            }
            if (columnIndex == 3) {
                return dimension.getSize().getDisplayString();
            }
            if (columnIndex == 4) {
                return "" + dimension.getWeight();
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

