/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.xml.model;

import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoDelete;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectAdd;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectMove;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectSetObjectAfter;

public final class SynchronizeManager {
    private final IDatabindingsProvider m_provider;

    public SynchronizeManager(IDatabindingsProvider provider, XmlObjectInfo xmlObjectRoot) {
        this.m_provider = provider;
        xmlObjectRoot.addBroadcastListener((Object)new ObjectInfoDelete(){

            public void after(ObjectInfo parent, ObjectInfo child) throws Exception {
                SynchronizeManager.this.synchronizeObserves();
            }
        });
        xmlObjectRoot.addBroadcastListener((Object)new XmlObjectAdd(){

            public void after(ObjectInfo parent, final XmlObjectInfo child) throws Exception {
                child.addBroadcastListener((Object)new XmlObjectSetObjectAfter(){

                    public void invoke(XmlObjectInfo target, Object o) throws Exception {
                        if (child == target) {
                            target.removeBroadcastListener((Object)this);
                            SynchronizeManager.this.synchronizeObserves();
                        }
                    }
                });
            }
        });
        xmlObjectRoot.addBroadcastListener((Object)new XmlObjectMove(){

            public void after(XmlObjectInfo child, ObjectInfo oldParent, ObjectInfo newParent) throws Exception {
                SynchronizeManager.this.synchronizeObserves();
            }
        });
    }

    private void synchronizeObserves() throws Exception {
        this.m_provider.synchronizeObserves();
    }
}

