/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.selection;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Font;
import org.eclipse.wb.draw2d.Graphics;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.border.LineBorder;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.utils.ui.SwtResourceManager;
import org.eclipse.wb.internal.draw2d.SemiTransparentFigure;

public class TopResizeFigure
extends SemiTransparentFigure {
    private String m_sizeText;

    public TopResizeFigure() {
        super(64);
        this.setBackground(IColorConstants.lightGreen);
        this.setForeground(IColorConstants.darkGray);
        this.setBorder(new LineBorder(IColorConstants.darkBlue, 1));
    }

    public void setSizeText(String sizeText) {
        this.m_sizeText = sizeText;
    }

    protected void paintClientArea(Graphics graphics) {
        super.paintClientArea(graphics);
        if (!StringUtils.isEmpty((String)this.m_sizeText)) {
            Rectangle area = this.getClientArea();
            Font font = SwtResourceManager.getFont("Arial", 16, 0);
            graphics.setFont(font);
            Dimension textExtent = graphics.getTextExtent(this.m_sizeText);
            int x = area.x + (area.width - textExtent.width) / 2;
            int y = area.y + (area.height - textExtent.height) / 2;
            graphics.drawString(this.m_sizeText, x, y);
        }
    }
}

