/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.draw2d.geometry;

import java.io.Serializable;

public final class Insets
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final Insets ZERO_INSETS = new Insets();
    public int top;
    public int left;
    public int bottom;
    public int right;

    public Insets() {
    }

    public Insets(Insets insets) {
        this(insets.top, insets.left, insets.bottom, insets.right);
    }

    public Insets(int value) {
        this(value, value, value, value);
    }

    public Insets(int top, int left, int bottom, int right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public int getHeight() {
        return this.top + this.bottom;
    }

    public int getWidth() {
        return this.left + this.right;
    }

    public boolean isEmpty() {
        return this.left == 0 && this.right == 0 && this.top == 0 && this.bottom == 0;
    }

    public Insets add(Insets insets) {
        this.top += insets.top;
        this.bottom += insets.bottom;
        this.left += insets.left;
        this.right += insets.right;
        return this;
    }

    public Insets transpose() {
        int temp = this.top;
        this.top = this.left;
        this.left = temp;
        temp = this.right;
        this.right = this.bottom;
        this.bottom = temp;
        return this;
    }

    public Insets getAdded(Insets insets) {
        return new Insets(this).add(insets);
    }

    public Insets getTransposed() {
        return new Insets(this).transpose();
    }

    public Insets getNegated() {
        return new Insets(-this.top, -this.left, -this.bottom, -this.right);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.bottom;
        result = 31 * result + this.left;
        result = 31 * result + this.right;
        result = 31 * result + this.top;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Insets other = (Insets)obj;
        if (this.bottom != other.bottom) {
            return false;
        }
        if (this.left != other.left) {
            return false;
        }
        if (this.right != other.right) {
            return false;
        }
        return this.top == other.top;
    }

    public String toString() {
        return "Insets(t=" + this.top + ", l=" + this.left + ", b=" + this.bottom + ", r=" + this.right + ")";
    }

    public static Insets min(Insets insets_1, Insets insets_2) {
        return new Insets(Math.min(insets_1.top, insets_2.top), Math.min(insets_1.left, insets_2.left), Math.min(insets_1.bottom, insets_2.bottom), Math.min(insets_1.right, insets_2.right));
    }
}

