/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.property;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.broadcast.GenericPropertyGetValue;
import org.eclipse.wb.internal.core.xml.model.broadcast.GenericPropertySetExpression;
import org.eclipse.wb.internal.core.xml.model.broadcast.GenericPropertySetValue;
import org.eclipse.wb.internal.core.xml.model.clipboard.IClipboardSourceProvider;
import org.eclipse.wb.internal.core.xml.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.xml.model.property.GenericProperty;
import org.eclipse.wb.internal.core.xml.model.property.GenericPropertyComposite;
import org.eclipse.wb.internal.core.xml.model.property.IExpressionPropertyEditor;
import org.eclipse.wb.internal.core.xml.model.property.ISetValuePropertyEditor;
import org.eclipse.wb.internal.core.xml.model.property.accessor.ContentExpressionAccessor;
import org.eclipse.wb.internal.core.xml.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.xml.model.property.converter.ExpressionConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenericPropertyImpl
extends GenericProperty {
    private final GenericPropertyDescription m_description;
    private final ExpressionConverter m_converter;

    public GenericPropertyImpl(XmlObjectInfo object, GenericPropertyDescription description) {
        this(object, description, description.getTitle());
    }

    public GenericPropertyImpl(GenericPropertyImpl property, String title) {
        this(property.getObject(), property.getDescription(), title);
    }

    private GenericPropertyImpl(XmlObjectInfo object, GenericPropertyDescription description, String title) {
        super(object, title, description.getEditor());
        this.m_description = description;
        this.setCategory(description.getCategory());
        this.m_converter = this.m_description.getConverter();
    }

    public GenericPropertyDescription getDescription() {
        return this.m_description;
    }

    public Class<?> getType() {
        return this.m_description.getType();
    }

    @Override
    public boolean hasTrueTag(String tag) {
        return this.m_description.hasTrueTag(tag);
    }

    public boolean isModified() throws Exception {
        for (ExpressionAccessor accessor : this.getAccessors()) {
            if (!accessor.isModified(this.m_object)) continue;
            return true;
        }
        return false;
    }

    public Object getValue() throws Exception {
        Object[] valueArray = new Object[]{UNKNOWN_VALUE};
        ((GenericPropertyGetValue)this.m_object.getBroadcast(GenericPropertyGetValue.class)).invoke(this, valueArray);
        if (valueArray[0] != UNKNOWN_VALUE) {
            return valueArray[0];
        }
        Object value = this.m_description.getAccessor().getValue(this.m_object);
        if (value != UNKNOWN_VALUE) {
            return value;
        }
        return this.getDefaultValue();
    }

    @Override
    protected void setValueEx(Object value) throws Exception {
        Object[] valueToValidate = new Object[]{value};
        boolean[] validationStatus = new boolean[]{true};
        ((GenericPropertySetValue)this.m_object.getBroadcast(GenericPropertySetValue.class)).invoke(this, valueToValidate, validationStatus);
        if (!validationStatus[0]) {
            return;
        }
        value = valueToValidate[0];
        if (this.m_editor instanceof ISetValuePropertyEditor) {
            ((ISetValuePropertyEditor)this.m_editor).setValue(this, value);
            return;
        }
        Object defaultValue = this.getDefaultValue();
        String expression = value == UNKNOWN_VALUE || ObjectUtils.equals((Object)value, (Object)defaultValue) ? (this.hasTrueTag("x-keepDefault") ? this.m_converter.toSource(this.m_object, defaultValue) : null) : (this.m_editor instanceof IExpressionPropertyEditor ? ((IExpressionPropertyEditor)this.m_editor).getValueExpression(this, value) : this.m_converter.toSource(this.m_object, value));
        this.setExpression(expression, value);
    }

    @Override
    public String getExpression() {
        for (ExpressionAccessor accessor : this.getAccessors()) {
            String expression = accessor.getExpression(this.m_object);
            if (expression == null) continue;
            return expression;
        }
        return null;
    }

    @Override
    public void setExpression(String expression, Object value) throws Exception {
        String[] expressionToValidate = new String[]{expression};
        Object[] valueToValidate = new Object[]{value};
        boolean[] validationStatus = new boolean[]{true};
        ((GenericPropertySetExpression)this.m_object.getBroadcast(GenericPropertySetExpression.class)).invoke(this, expressionToValidate, valueToValidate, validationStatus);
        if (!validationStatus[0]) {
            return;
        }
        expression = expressionToValidate[0];
        value = valueToValidate[0];
        if (value != UNKNOWN_VALUE && !this.hasTrueTag("x-keepDefault") && ObjectUtils.equals((Object)value, (Object)this.getDefaultValue())) {
            expression = null;
        }
        this.setExpression0(expression);
    }

    private void setExpression0(String expression) throws Exception {
        List<ExpressionAccessor> accessors = this.getAccessors();
        for (ExpressionAccessor accessor : accessors) {
            if (!accessor.isModified(this.m_object)) continue;
            accessor.setExpression(this.m_object, expression);
            return;
        }
        accessors.get(0).setExpression(this.m_object, expression);
    }

    public List<ExpressionAccessor> getAccessors() {
        ArrayList accessors = Lists.newArrayList();
        if (this.m_description.hasTrueTag("isContent")) {
            accessors.add(ContentExpressionAccessor.INSTANCE);
        }
        accessors.add(this.m_description.getAccessor());
        return accessors;
    }

    private Object getDefaultValue() throws Exception {
        Object defaultValue = this.m_description.getDefaultValue();
        if (defaultValue != UNKNOWN_VALUE) {
            return defaultValue;
        }
        return this.m_description.getAccessor().getDefaultValue(this.m_object);
    }

    public Property getComposite(Property[] properties) {
        return GenericPropertyComposite.create(properties);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == PropertyTooltipProvider.class) {
            return this.m_description.getAccessor().getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }

    public String getClipboardSource() throws Exception {
        if (!this.isModified()) {
            return null;
        }
        if (this.m_editor instanceof IClipboardSourceProvider) {
            return ((IClipboardSourceProvider)this.m_editor).getClipboardSource(this);
        }
        if (this.m_converter != null) {
            return this.m_converter.toSource(this.m_object, this.getValue());
        }
        return null;
    }
}

