/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.dialogfields;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;

public class CheckDialogField
extends DialogField {
    private boolean m_selection;
    private Button m_buttonControl;
    private SelectionListener m_selectionListener;

    public Control[] doFillIntoGrid(Composite parent, int columns) {
        this.assertEnoughColumns(columns);
        Button button = this.getButtonControl(parent);
        GridDataFactory.create((Control)button).alignHF().spanH(columns);
        return new Control[]{button};
    }

    public Button getButtonControl(Composite parent) {
        if (this.m_buttonControl == null) {
            this.assertCompositeNotNull(parent);
            this.m_selectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    CheckDialogField.this.doModifySelection(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    CheckDialogField.this.doModifySelection(e);
                }
            };
            this.m_buttonControl = new Button(parent, 32);
            if (this.fLabelText != null) {
                this.m_buttonControl.setText(this.fLabelText);
            }
            this.m_buttonControl.setSelection(this.m_selection);
            this.m_buttonControl.addSelectionListener(this.m_selectionListener);
            this.m_buttonControl.setFont(parent.getFont());
            this.m_buttonControl.setEnabled(this.isEnabled());
        }
        return this.m_buttonControl;
    }

    private void doModifySelection(SelectionEvent e) {
        if (this.isOkToUse((Control)this.m_buttonControl)) {
            this.m_selection = this.m_buttonControl.getSelection();
        }
        this.dialogFieldChanged();
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.m_buttonControl)) {
            this.m_buttonControl.setEnabled(this.isEnabled());
        }
    }

    public boolean getSelection() {
        return this.m_selection;
    }

    public void setSelection(boolean selection) {
        this.m_selection = selection;
        if (this.isOkToUse((Control)this.m_buttonControl)) {
            this.m_buttonControl.setSelection(this.m_selection);
        } else {
            this.dialogFieldChanged();
        }
    }

    public void setSelectionWithoutUpdate(boolean selection) {
        this.m_selection = selection;
        if (this.isOkToUse((Control)this.m_buttonControl)) {
            this.m_buttonControl.removeSelectionListener(this.m_selectionListener);
            this.m_buttonControl.setSelection(selection);
            this.m_buttonControl.addSelectionListener(this.m_selectionListener);
        }
    }

    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.m_buttonControl)) {
            this.setSelectionWithoutUpdate(this.m_selection);
        }
    }
}

