/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.model;

import com.google.common.collect.Lists;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.RowSpec;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.swing.FormLayout.model.FormDimensionTemplate;
import org.eclipse.wb.internal.swing.FormLayout.model.FormDimensionUtils;
import org.eclipse.wb.internal.swing.FormLayout.model.FormSizeConstantInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormSizeInfo;

public abstract class FormDimensionInfo {
    private final boolean m_horizontal;
    private FormSizeInfo m_size;
    private FormSpec.DefaultAlignment m_alignment;
    private double m_weight;
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.ENGLISH));

    public FormDimensionInfo(FormSpec spec) throws Exception {
        this.m_horizontal = spec instanceof ColumnSpec;
        this.setFormSpec(spec);
    }

    public String toString() {
        return this.getDisplayString();
    }

    public boolean equals2(Object obj) {
        FormDimensionInfo dimension = (FormDimensionInfo)obj;
        return dimension.m_alignment == this.m_alignment && dimension.m_size.getSize().equals(this.m_size.getSize()) && dimension.m_weight == this.m_weight;
    }

    public final FormSizeInfo getSize() {
        return this.m_size;
    }

    public final FormSpec.DefaultAlignment getAlignment() {
        return this.m_alignment;
    }

    public final void setAlignment(FormSpec.DefaultAlignment alignment) {
        this.m_alignment = alignment;
    }

    public final double getWeight() {
        return this.m_weight;
    }

    public final void setWeight(double weight) {
        this.m_weight = weight;
    }

    public final boolean isGap() {
        Field field = this.getTemplateField();
        return field != null && field.getName().indexOf("GAP") != -1;
    }

    public final boolean hasGrow() {
        return this.m_weight != 0.0;
    }

    public void convertToNearestGap(int maxDelta) throws Exception {
        Assert.isNotNull((Object)this.m_size.getConstantSize());
        Assert.isTrue((this.m_size.getConstantSize().getUnit() == ConstantSize.PIXEL ? 1 : 0) != 0);
        int thisPixels = (int)this.m_size.getConstantSize().getValue();
        int minDelta = Integer.MAX_VALUE;
        Field minField = null;
        Field[] fields = FormDimensionUtils.getTemplateFields();
        int i = 0;
        while (i < fields.length) {
            ConstantSize constantSize;
            int sizeInPixels;
            int delta;
            FormSpec formSpec;
            Field field = fields[i];
            if ((!this.m_horizontal || ColumnSpec.class.isAssignableFrom(field.getType())) && (this.m_horizontal || RowSpec.class.isAssignableFrom(field.getType())) && (formSpec = (FormSpec)field.get(null)).getSize() instanceof ConstantSize && formSpec.getResizeWeight() == 0.0 && (delta = Math.abs((sizeInPixels = (constantSize = (ConstantSize)formSpec.getSize()).getPixelSize(FormSizeConstantInfo.m_toolkitComponent)) - thisPixels)) <= maxDelta && delta < minDelta) {
                minDelta = delta;
                minField = field;
            }
            ++i;
        }
        if (minField != null) {
            this.setFormSpec((FormSpec)minField.get(null));
        }
    }

    public abstract FormDimensionInfo copy() throws Exception;

    public abstract FormDimensionTemplate[] getTemplates();

    public final FormDimensionTemplate[] getTemplates(boolean similar) {
        boolean isComponent;
        boolean bl = isComponent = !this.isGap();
        boolean needComponent = similar ? isComponent : !isComponent;
        List selectedTemplates = Lists.newArrayList();
        FormDimensionTemplate[] templates = this.getTemplates();
        int i = 0;
        while (i < templates.length) {
            FormDimensionTemplate template = templates[i];
            if (template.isComponent() == needComponent) {
                selectedTemplates.add(template);
            }
            ++i;
        }
        return selectedTemplates.toArray(new FormDimensionTemplate[selectedTemplates.size()]);
    }

    public final FormDimensionTemplate getTemplate() {
        FormDimensionTemplate[] templates = this.getTemplates();
        int i = 0;
        while (i < templates.length) {
            FormDimensionTemplate template = templates[i];
            if (this.isTemplate(template)) {
                return template;
            }
            ++i;
        }
        return null;
    }

    public final boolean isTemplate(FormDimensionTemplate template) {
        Field field = this.getTemplateField();
        return field != null && field.getName().equals(template.getFieldName());
    }

    public final void setTemplate(FormDimensionTemplate template) throws Exception {
        Field field = FormFactory.class.getField(template.getFieldName());
        this.setFormSpec((FormSpec)field.get(null));
    }

    public final void assign(FormDimensionInfo dimension) throws Exception {
        this.setFormSpec(dimension.getFormSpec());
    }

    public final String getToolTip() {
        FormDimensionTemplate template = this.getTemplate();
        if (template != null) {
            return template.getTitle();
        }
        return this.getDisplayString();
    }

    public String getDisplayString() {
        FormSpec.DefaultAlignment defaultAlignment;
        String encoded = this.m_size.getDisplayString();
        FormSpec.DefaultAlignment defaultAlignment2 = defaultAlignment = this.m_horizontal ? ColumnSpec.DEFAULT : RowSpec.DEFAULT;
        if (this.m_alignment != defaultAlignment) {
            encoded = this.m_alignment + ":" + encoded;
        }
        if (this.m_weight != 0.0) {
            encoded = this.m_weight == 1.0 ? String.valueOf(encoded) + ":grow" : String.valueOf(encoded) + ":grow(" + FORMAT.format(this.m_weight) + ")";
        }
        return encoded;
    }

    public final String getSource() {
        String sourceType;
        Field field = this.getTemplateField();
        if (field != null) {
            return "com.jgoodies.forms.factories.FormFactory." + field.getName();
        }
        String string = sourceType = this.m_horizontal ? "com.jgoodies.forms.layout.ColumnSpec" : "com.jgoodies.forms.layout.RowSpec";
        if (this.m_size.isString()) {
            FormSpec.DefaultAlignment defaultAlignment;
            String encoded = this.m_size.getSource();
            FormSpec.DefaultAlignment defaultAlignment2 = defaultAlignment = this.m_horizontal ? ColumnSpec.DEFAULT : RowSpec.DEFAULT;
            if (this.m_alignment != defaultAlignment) {
                encoded = this.m_alignment + ":" + encoded;
            }
            if (this.m_weight != 0.0) {
                encoded = this.m_weight == 1.0 ? String.valueOf(encoded) + ":grow" : String.valueOf(encoded) + ":grow(" + FORMAT.format(this.m_weight) + ")";
            }
            return String.valueOf(sourceType) + ".decode(\"" + encoded + "\")";
        }
        String source = "new " + sourceType + "(";
        source = String.valueOf(source) + FormDimensionInfo.getAlignmentSource(this.m_horizontal, this.m_alignment);
        source = String.valueOf(source) + ", ";
        source = String.valueOf(source) + this.m_size.getSource();
        source = String.valueOf(source) + ", ";
        source = String.valueOf(source) + FORMAT.format(this.m_weight);
        return String.valueOf(source) + ")";
    }

    private static String getAlignmentSource(boolean horizontal, FormSpec.DefaultAlignment alignment) {
        String source;
        if (horizontal) {
            String source2;
            if (alignment == ColumnSpec.LEFT) {
                source2 = "LEFT";
            } else if (alignment == ColumnSpec.CENTER) {
                source2 = "CENTER";
            } else if (alignment == ColumnSpec.RIGHT) {
                source2 = "RIGHT";
            } else {
                Assert.isTrue((alignment == ColumnSpec.FILL ? 1 : 0) != 0);
                source2 = "FILL";
            }
            return "com.jgoodies.forms.layout.ColumnSpec." + source2;
        }
        if (alignment == RowSpec.TOP) {
            source = "TOP";
        } else if (alignment == RowSpec.CENTER) {
            source = "CENTER";
        } else if (alignment == RowSpec.BOTTOM) {
            source = "BOTTOM";
        } else {
            Assert.isTrue((alignment == RowSpec.FILL ? 1 : 0) != 0);
            source = "FILL";
        }
        return "com.jgoodies.forms.layout.RowSpec." + source;
    }

    private Field getTemplateField() {
        FormSpec formSpec = this.getFormSpec();
        return FormDimensionUtils.getFormFactoryTemplate(formSpec);
    }

    public final FormSpec getFormSpec() {
        if (this.m_horizontal) {
            return new ColumnSpec(this.m_alignment, this.m_size.getSize(), this.m_weight);
        }
        return new RowSpec(this.m_alignment, this.m_size.getSize(), this.m_weight);
    }

    private void setFormSpec(FormSpec spec) throws Exception {
        this.m_size = new FormSizeInfo(spec.getSize(), this.m_horizontal);
        this.m_alignment = spec.getDefaultAlignment();
        this.m_weight = spec.getResizeWeight();
    }
}

