/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.editor.DesignPageSite;
import org.eclipse.wb.internal.core.editor.ObjectPathHelper;
import org.eclipse.wb.internal.core.editor.structure.components.IComponentsTree;
import org.eclipse.wb.internal.core.xml.editor.IRefreshStrategy;
import org.eclipse.wb.internal.core.xml.editor.XmlDesignPage;
import org.eclipse.wb.internal.core.xml.model.EditorContextCommitListener;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;

public final class UndoManager {
    private final XmlDesignPage m_designPage;
    private final IDocument m_document;
    private String m_currentSource;
    private String m_currentDump;
    private IComponentsTree m_componentsTree;
    private ISelectionProvider m_selectionProvider;
    private ITreeContentProvider m_componentsProvider;
    private ObjectPathHelper m_objectPathHelper;
    private final Map<String, int[][]> m_dumpToSelection = new LRUMap(32);
    private final Map<String, int[][]> m_dumpToExpanded = new LRUMap(32);
    private boolean m_active;
    private XmlObjectInfo m_rootObject;
    private int m_bufferChangeCount = 0;
    private IRefreshStrategy m_refreshStrategy = IRefreshStrategy.IMMEDIATELY;
    private final IDocumentListener m_documentListener = new IDocumentListener(){

        public void documentChanged(DocumentEvent event) {
            if (event.getText() != null || event.getLength() != 0) {
                this.scheduleRefresh_onBufferChange();
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        private void scheduleRefresh_onBufferChange() {
            UndoManager undoManager = UndoManager.this;
            int n = undoManager.m_bufferChangeCount + 1;
            undoManager.m_bufferChangeCount = n;
            final int bufferChangeCount = n;
            Runnable runnable = new Runnable(){

                public void run() {
                    if (bufferChangeCount == UndoManager.this.m_bufferChangeCount) {
                        UndoManager.this.refreshDesignerEditor();
                    }
                }
            };
            if (UndoManager.this.m_refreshStrategy.shouldImmediately()) {
                runnable.run();
            } else if (UndoManager.this.m_refreshStrategy.shouldWithDelay()) {
                int delay = UndoManager.this.m_refreshStrategy.getDelay();
                Display.getDefault().timerExec(delay, runnable);
            }
        }
    };
    private final EditorContextCommitListener m_commitListener = new EditorContextCommitListener(){

        public void aboutToCommit() {
            UndoManager.this.removeDocumentListener();
        }

        public void doneCommit() {
            UndoManager.this.addDocumentListener();
        }
    };
    private final ObjectEventListener m_refreshListener = new ObjectEventListener(){

        public void refreshBeforeCreate() throws Exception {
            UndoManager.this.removeSelectionListener();
        }

        public void refreshed2() throws Exception {
            UndoManager.this.addSelectionListener();
            UndoManager.this.rememberSource();
            UndoManager.this.rememberDump();
            UndoManager.this.rememberState();
        }
    };
    private final ISelectionChangedListener m_selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            UndoManager.this.rememberState();
        }
    };

    public UndoManager(XmlDesignPage designPage, IDocument document) {
        this.m_designPage = designPage;
        this.m_document = document;
    }

    public void activate() {
        if (!this.m_active) {
            this.m_active = true;
            if (!StringUtils.equals((String)this.m_currentSource, (String)this.m_document.get())) {
                this.refreshDesignerEditor();
            }
            this.addDocumentListener();
        }
    }

    public void deactivate() {
        this.m_active = false;
        this.removeDocumentListener();
    }

    public void setRoot(XmlObjectInfo rootObject) {
        this.m_rootObject = rootObject;
        rootObject.addBroadcastListener(this.m_commitListener);
        rootObject.addBroadcastListener(this.m_refreshListener);
        DesignPageSite site = DesignPageSite.Helper.getSite((ObjectInfo)rootObject);
        this.m_componentsTree = site.getComponentTree();
        this.m_componentsProvider = this.m_componentsTree.getContentProvider();
        this.m_selectionProvider = this.m_componentsTree.getSelectionProvider();
        this.m_objectPathHelper = new ObjectPathHelper(this.m_componentsProvider);
        this.m_componentsTree.setExpandListener(new Runnable(){

            public void run() {
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        UndoManager.this.rememberState();
                    }
                });
            }
        });
    }

    void setRefreshStrategy(IRefreshStrategy refreshStrategy) {
        this.m_refreshStrategy = refreshStrategy;
    }

    private void addDocumentListener() {
        this.m_document.addDocumentListener(this.m_documentListener);
    }

    private void removeDocumentListener() {
        this.m_document.removeDocumentListener(this.m_documentListener);
    }

    private void addSelectionListener() {
        this.m_selectionProvider.addSelectionChangedListener(this.m_selectionListener);
    }

    private void removeSelectionListener() {
        if (this.m_selectionProvider != null) {
            this.m_selectionProvider.removeSelectionChangedListener(this.m_selectionListener);
        }
    }

    void refreshDesignerEditor() {
        this.rememberSource();
        this.removeSelectionListener();
        if (this.m_designPage.internal_refreshGEF()) {
            this.addSelectionListener();
            this.rememberDump();
            this.restoreState();
        }
    }

    private void rememberSource() {
        this.m_currentSource = this.m_document.get();
    }

    private void rememberDump() {
        this.m_currentDump = ObjectPathHelper.getObjectsDump((ObjectInfo)this.m_rootObject, (int)0);
    }

    private void rememberState() {
        IStructuredSelection structuredSelection = (IStructuredSelection)this.m_selectionProvider.getSelection();
        Object[] selectedObjects = structuredSelection.toArray();
        int[][] paths = this.m_objectPathHelper.getObjectsPaths(selectedObjects);
        this.m_dumpToSelection.put(this.m_currentDump, paths);
        Object[] expandedObjects = this.m_componentsTree.getExpandedElements();
        paths = this.m_objectPathHelper.getObjectsPaths(expandedObjects);
        this.m_dumpToExpanded.put(this.m_currentDump, paths);
    }

    private void restoreState() {
        this.restoreSelection();
        this.restoreExpanded();
    }

    private void restoreSelection() {
        int[][] paths = this.m_dumpToSelection.get(this.m_currentDump);
        if (paths != null) {
            this.removeSelectionListener();
            try {
                Object[] objects = this.m_objectPathHelper.getObjectsForPaths(paths);
                this.m_selectionProvider.setSelection((ISelection)new StructuredSelection(objects));
            }
            finally {
                this.addSelectionListener();
            }
        }
    }

    private void restoreExpanded() {
        int[][] paths = this.m_dumpToExpanded.get(this.m_currentDump);
        if (paths != null) {
            Object[] objects = this.m_objectPathHelper.getObjectsForPaths(paths);
            this.m_componentsTree.setExpandedElements(objects);
        }
        if (this.m_componentsTree.getExpandedElements().length == 0) {
            List expandedElements = Lists.newArrayList();
            Object element = this.m_rootObject;
            while (true) {
                expandedElements.add(element);
                Object[] children = this.m_componentsProvider.getChildren(element);
                if (children.length != 1) break;
                element = children[0];
            }
            this.m_componentsTree.setExpandedElements(expandedElements.toArray());
        }
    }
}

