/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import java.text.MessageFormat;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.AbstractTextPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;

public class BytePropertyEditor
extends AbstractTextPropertyEditor {
    public static final PropertyEditor INSTANCE = new BytePropertyEditor();

    private BytePropertyEditor() {
    }

    public String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value instanceof Byte) {
            return value.toString();
        }
        return null;
    }

    protected String getEditorText(Property property) throws Exception {
        return this.getText(property);
    }

    protected boolean setEditorText(Property property, String text) throws Exception {
        Byte value;
        if ((text = text.trim()).length() == 0) {
            property.setValue(Property.UNKNOWN_VALUE);
        }
        try {
            value = Byte.valueOf(text);
        }
        catch (Throwable throwable) {
            UiUtils.openWarning(DesignerPlugin.getShell(), property.getTitle(), MessageFormat.format(ModelMessages.BytePropertyEditor_notValidByte, text));
            return false;
        }
        property.setValue(value);
        return true;
    }
}

