/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public final class GridLayoutFactory {
    private final GridLayout m_layout;

    private GridLayoutFactory(Composite composite, GridLayout layout) {
        this.m_layout = layout;
        composite.setLayout((Layout)this.m_layout);
    }

    public static GridLayoutFactory create(Composite composite) {
        return new GridLayoutFactory(composite, new GridLayout());
    }

    public static GridLayoutFactory modify(Composite composite) {
        Layout layout = composite.getLayout();
        if (layout instanceof GridLayout) {
            return new GridLayoutFactory(composite, (GridLayout)layout);
        }
        return GridLayoutFactory.create(composite);
    }

    public GridLayoutFactory columns(int numColumns) {
        this.m_layout.numColumns = numColumns;
        return this;
    }

    public GridLayoutFactory equalColumns() {
        this.m_layout.makeColumnsEqualWidth = true;
        return this;
    }

    public GridLayoutFactory marginsH(int margins) {
        this.m_layout.marginWidth = margins;
        return this;
    }

    public GridLayoutFactory marginsV(int margins) {
        this.m_layout.marginHeight = margins;
        return this;
    }

    public GridLayoutFactory margins(int margins) {
        this.m_layout.marginWidth = this.m_layout.marginHeight = margins;
        return this;
    }

    public GridLayoutFactory noMargins() {
        this.m_layout.marginHeight = 0;
        this.m_layout.marginWidth = 0;
        return this;
    }

    public GridLayoutFactory noSpacing() {
        this.m_layout.verticalSpacing = 0;
        this.m_layout.horizontalSpacing = 0;
        return this;
    }

    public GridLayoutFactory spacingH(int spacing) {
        this.m_layout.horizontalSpacing = spacing;
        return this;
    }

    public GridLayoutFactory spacingV(int spacing) {
        this.m_layout.verticalSpacing = spacing;
        return this;
    }
}

